#ifndef __CHARACTER_ALPHABET__
#define __CHARACTER_ALPHABET__

#include <string>

using namespace std;

class CharacterAlphabet {

  public:

  CharacterAlphabet() { }

  CharacterAlphabet(const string& _characters, const string& _gapChars) 
    : characters(_characters), gapChars(_gapChars) { }
  
  CharacterAlphabet(const CharacterAlphabet& other) {
    copy(other);
  }

  virtual ~CharacterAlphabet() { }

  /** returns number of different non-gap charcters */
  unsigned int size() const { return characters.size(); }

  char getChar(unsigned int n) const { return characters[n]; }

  const string& getCharacters() const { return characters; }

  const string& getGapChars() const { return gapChars; }

  /** returns true if is gap character */
  bool isGap(char c) const {
    return contains(gapChars, c);
  }

  /** returns true if character is found in string */
  static bool contains(const string& s, char c) {
    for (unsigned int i = 0; i < s.size(); ++i) {
      if (s[i] == c) {
	return true;
      }
    }
      return false;
  }

 private:

  /* MODIFIERS */
  void copy(const CharacterAlphabet& other) {
    characters = other.characters;
    gapChars = other.gapChars;
  }

  /* ATTRIBUTES */

  string characters;

  string gapChars;

};

#endif
