// --*- C++ -*------x---------------------------------------------------------
// $Id: VrmlMatrixWriterBase.h,v 1.1 2005/07/11 20:22:10 bindewae Exp $
//
// Class:           MatrixWriterBase
// 
// Base class:      -
//
// Derived classes: AbstractMatrixWriter, Vrml2MatrixWriter, JVXMatrixWriter
//
// Author:          Eckart Bindewald
//
// Project name:    -
//
// Date:            07/2005
//
// Description:     Base class for generating 3D model of 3D sequence logo
// 
// Reviewed by:     -
// -----------------x-------------------x-------------------x-----------------

#ifndef __MATRIX_WRITER_BASE_H__
#define __MATRIX_WRITER_BASE_H__

// Includes

#include <iostream>
#include <debug.h>
#include <Vec.h>
#include <Alignment.h>
#include <Stem.h>

using namespace std;

/** Base class for writing 3D output used for representing RNA alignments. 

    @author Eckart Bindewald
    @see    -
    @review - */
class MatrixWriterBase {

public:

  virtual ~MatrixWriterBase() { }

  /* OPERATORS */

  /* PREDICATES */

  /** central method */
  /*
  virtual void writeVrml(ostream& os,
			 const Alignment& ali,
			 const Vec<Stem>& stems) const { }
  */
  /** central method */
  virtual void writeVrml(ostream& os, const Alignment& ali,
			 const Vec<Vec<double> >& matrix,
			 const Vec<Vec<double> >& errorMatrix,
			 const Vec<double>& infVec,
			 const Vec<double>& infErrorVec,
			 const Vec<Stem>& referenceStems) const = 0;
  
  /* MODIFIERS */


};

#endif

