// --*- C++ -*------x---------------------------------------------------------
// $Id: ResourceBundle.h,v 1.1 2005/07/09 15:24:58 bindewae Exp $
//
// Class:           ResourceBundle
// 
// Base class:      -
//
// Derived classes: - 
//
// Author:          Eckart Bindewald
//
// Project name:    -
//
// Date:            7/2005
//
// Description:     manage string properties
// 
// Reviewed by:     -
// -----------------x-------------------x-------------------x-----------------

#ifndef __RESOURCE_BUNDLE_H__
#define __RESOURCE_BUNDLE_H__

// Includes

#include <iostream>

#include <debug.h>
#include <map>

using namespace std;

/** Used for storing string properties
    @author Eckart Bindewald
    @see    ResourceBundleClass in java J2SE SDK
    @review - */
class ResourceBundle {
public:
  ResourceBundle();

  ResourceBundle(const ResourceBundle& orig);

  virtual ~ResourceBundle();

  /* OPERATORS */

  /** Assigment operator. */
  ResourceBundle& operator = (const ResourceBundle& orig);

  friend ostream& operator << (ostream& os, const ResourceBundle& rval);
  friend istream& operator >> (istream& is, ResourceBundle& rval);

  /* PREDICATES */

  /** How big is object? */
  virtual unsigned int size() const { return dict.size(); }

  virtual string getString(const string& s) const;

  /* MODIFIERS */

  virtual void clear() { dict.clear(); }

protected:
  /* OPERATORS  */
  /* PREDICATES */
  /* MODIFIERS  */
  void copy(const ResourceBundle& other);

private:
  /* OPERATORS  */
  /* PREDICATES */
  /* MODIFIERS  */

private:
  /* PRIVATE ATTRIBUTES */
  mutable map<string, string> dict;

};

#endif /* __ACLASS_H__ */

