// -*-C++-*-------------------------------------------------------------------
//
// descriptipton: changes string to integer, double, float or long
// changes integer, double, float or long to string 
//
// error: if the input is no number (e.g. char or string)  then error,
// if wrong input (e.g. integer expected but float given) then error
//
// ---------------------------------------------------------------------------

#ifndef __STRING_TOOLS_H__
#define __STRING_TOOLS_H__

#include <iostream>
#include <sstream>
#include <string> // stl string class
#include <vector>
#include <debug.h>
#include <Vec.h>

using namespace std;

// #ifndef __MS_WINDOWS__
const char DIR_CHAR = '/';
// #else
// const char DIR_CHAR = '\\';
// #endif

const string LOWER_LETTER_STRING = "abcdefghijklmnopqrstuvwxyz";
const string UPPER_LETTER_STRING = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
const string LETTER_STRING = UPPER_LETTER_STRING + LOWER_LETTER_STRING;
const string DIGIT_STRING = "0123456789";


/** changes string into integer: */
int stoi( const string& );
/** changes string into unsigned integer: */
unsigned int stoui( const string& ); 
/** changes string into long: */
long stol( const string& );
/** changes string into float: */
float stof( const string& );
/** changes string into double: */
double stod( const string& );
/** changes string to vector of integer. Format: n1 n2 n3 ... */
vector<int> sToVectorOfInt( const string&);
/** changes string to vector of unsigned integer. Format: n1 n2 n3 ... */
vector<unsigned int> sToVectorOfUInt( const string&);

/** changes integer into string: */
string itos( const int& );
/** changes unsigned integer into string: */
string uitos( const unsigned int& );
/** changes long into string; */
string ltos( const long& );
/** changes float into string: */
string ftos( const float& );
/** changes double into string: */
string dtos( const double& );
/** translate vector of char to string */
string vtos( const Vec<char>& v);

/** returns true, if number in form [+|-]d*.d* with d being a digit
  exponential notation (like 1e-3) is not recognized! */
bool isSimpleDecimal(const string& sOrig);

/** tokenize text line */
vector<string> getTokens(const string& s);

// tokenize text seperated by set of delimiters
vector<string> getTokens(const string& text, const string& delim);

// tokenize text seperated by set of delimiters,
// return also vector with position indices of words
vector<string> getTokens(const string& text, const string& delim,
			 vector<unsigned int>& positions);

/** parses a string of the form "-3,5-8,12" to the numbers 1,2,3,5,6,7,8,12 */
Vec<unsigned int>
parseStringToVector(const string& s);

/* auxilary function for file reading */
/* skip whitespace */
void eatWhite(istream& is);

// skips over whitespace and comments (starting with '#')
void eatWhiteAndComment(istream& is);

// skips to new line
void skipToNewLine(istream& is);

// return string with actual line. Reads last newline, but does not include it.
string getLine(istream& is);

/** return string which consists of concetenated regions represented
    by single character. Characters in removeList are removed. */
string getBlocks(const string& orig, const vector<char>& removeList);

/** return string which consists of concetenated regions represented
    by single character. Characters in removeList are removed. */
string getBlocks(const string& orig);

/** return string with removed identical neighbouring characters */
// string uniqueString(const string& sOrig);

/** remove all occurences of char c from string and return result */
string removeFromString(const string& s, char c);

/** remove all occurences of char c from string and return result */
string removeFromStringParallel(const string& s, char c,
				string other,
				string& otherresult);

/** remove all occurences of any charactor from removeSet from string and 
    return result */
string removeFromString(const string& s, const string&  removeSet);

/** remove all occurences of any charactor from removeSet from string and 
    return result */
string removeWhiteSpaceFromString(const string& s);

/** remove all occurences of char c from string and return result */
string squeezeRepeats(const string& s, char c);

/** remove all occurences of char c from string and return result */
string squeezeRepeats(const string& s, const string& letters);

/** 
 * returns true if character is white space 
 * @see http://www.jimprice.com/ascii-0-127.gif  (ASCII table)
 */
inline
bool
isWhiteSpace(char c) {
  bool b1 = ((c == ' ') || (c == '\t') || (c == '\n') || (c == '\r'));
  int ic = (int)c;

  bool b2 = (ic == 9)|| (ic == 10) || (ic == 11) || (ic == 12) || (ic == 13);
  return b1 || b2;
}

/** 
 * removes all occurences of any charactor from removeSet from string and return result 
 * @review  not yet tested!
 */
string trimWhiteSpaceFromString(const string& s);

/** 
 * removes leading or trailing occurectns of any charactor from letters from string and return result 
 * @review  not yet tested!
 */
string trim(const string& s, const string& letters);

/** replace each occurence of c1 by c2 */
string translate(const string& s, char oldChar, char newChar);

/**
 * Reverses order of string. Not very efficient.
 */
string
reverseString(const string& s);

// replace all letters by upper case version */
void upperCase(string& s);

// replace all letters by lower case version */
void lowerCase(string& s);

// return true if no characters are lower case
bool isAllUpper(const string& s);

// return true if no characters are upper case
bool isAllLower(const string& s);

/** 
 * returns true if content of two strings identical
 */
inline 
bool isEqual(const string& s1, const string& s2) {
  return (s1.compare(s2) == 0);
}

/* print n time character c to stream */
void
printChar(ostream& os, char c, unsigned int n);

/** return vector with positions, at which character c is found in string */
vector<unsigned int> findPositions(const string& s, char c);

// read non-empty lines until end of file reached
vector<string> getLines(istream& is);


/** 
 * returns string with call command
 */
string
callString(int argc, char** argv);

/**
 * interprets environment variables of the form like "HOSTNAME=mast3"
 * would set pararameterName to HOSTNAME and parameterValue to mast3
 * in this case
 */
void
parseParameter(const string& s, string& parameterName, string& paramterValue);

/**
 * tries to find parameterValue of parameter. Entries must have form described in
 * parseparameter. Used to reading environment variables.
 */ 
string
getParameterValue(char **envp, const string& parameterNameOrig,
                  const string& defaultValue);

/** keep only subset of characters defined by subset */
string
getSubset(const string& s, const Vec<unsigned int>& subset);


/** finds index of word in vector of strings */
unsigned int
findWordIndex(const Vec<string>& dict, const string& word);

#endif // __STRING_2_NUMBER_H__



