#include <MAFAlignment.h>
#include <BEDRegions.h>
#include <StringTools.h>

MAFAlignment::length_type MAFAlignment::unloadCharLimit = 10000;

void helpOutput(ostream& os) {
  os << "Extracts a sequence fragment from a MAF format file for a given assembly name and assembly coordinates" << endl
     << "usage: filtermaf MAFfile ASSEMBLY MINPOS MAXPOS" << endl;
}

int main(int argc, char ** argv) {
  if (argc != 5) {
    helpOutput(cout);
    exit(0);
  }
  MAFAlignment maf;
  string filename(argv[1]);
  string currAssembly(argv[2]);
  maf.setRefAssembly(currAssembly);
  maf.setVerbose(0);
  MAFAlignment::length_type minCoord = stoi(string(argv[3]));
  MAFAlignment::length_type maxCoord = stoi(string(argv[4]));
  ifstream ifs(filename.c_str());
  ERROR_IF(!ifs, "Error opening input filename!");
  maf.read(ifs);
  cout << maf.extractAssemblySequence(minCoord, maxCoord) << endl;
  ifs.close();
}

