#ifndef _GEOMETRY_TOOLS_
#define _GEOMETRY_TOOLS_

#include <math.h>

#ifndef PI
#define PI 3.141592654
#endif

class GeometryTools {

 public:

  static double sphereVolume(double r) {
    return (4.0/3.0) * PI * r * r * r;
  }

  /** Intersection volumn of intersection lens of two spheres with radius r1 and r2 and distance d.
   From: http://mathworld.wolfram.com/Sphere-SphereIntersection.html.
  Modification for one sphere withing the other */
  static double sphereIntersectionVolume(double r1, double r2, double d) {
    PRECOND(r1 >= 0.0);
    PRECOND(r2 >= 0.0);
    // PRECOND((d >= 0) && (r1 >= 0.0) && (r2 >= 0.0));
    if ((r1 == 0.0) || (r2 == 0.0) || (r1 + r2 < d)) {
      return 0.0;
    }
    if (d <= (fabs(r1 - r2))) { // one sphere lies completely within the other; always the case for d == 0.0
      double rMin = r1;
      if (r2 < rMin) {
	rMin = r2;
      }
      return sphereVolume(rMin);
    }
    double term1 = r1 + r2 -d;
    ASSERT(term1 > -0.1);
    if (term1 < 0.0) {
      term1 = 0.0;
    }
    ASSERT(term1 >= 0.0);
    double term2 = (d*d) + (2*d*r1) - (3*r1*r1) + (2*d*r2) + (6*r1*r2) - (3*r2*r2);
    ASSERT(term2 > -0.1);
    if (term2 < 0.0) {
      term2 = 0.0;
    }
    ASSERT(term2 >= 0.0);
    double volume = PI * term1 * term1 * term2 / (12.0 * d);
    return volume;
  }

};


#endif
