// --*- C++ -*------x---------------------------------------------------------
// $Id: RankedSolution7.h,v 1.2 2009/03/03 20:58:41 bindewae Exp $
//
// Class:           RankedSolution7
// 
// Base class:      -
//
// Derived classes: - 
//
// Author:          Eckart Bindewald
//
// Description:     Implements ranked solutions
// 
// Reviewed by:     -
// -----------------x-------------------x-------------------x-----------------

#ifndef __RANKED_SOLUTION7_H__
#define __RANKED_SOLUTION7_H__

// Includes

#include <iostream>
#include <debug.h>

template<class T, class S = int, class R = int, class U = int>
class RankedSolution7 {
public:
  RankedSolution7<T, S, R, U>() : first(0.0) { } 

  RankedSolution7<T, S, R, U>(double _first, const T& _second, const S& _third, const R& _fourth) : 
    first(_first), second(_second), third(_third), fourth(_fourth) { }

  RankedSolution7<T, S, R, U>(const RankedSolution7<T, S, R, U>& orig) { copy(orig); }

  virtual ~RankedSolution7<T, S, R, U>() {} 

  /* OPERATORS */

  /** Assigment operator. */
  RankedSolution7<T, S, R, U>& operator = (const RankedSolution7<T, S, R, U>& orig) {
    if (&orig != this) {
      copy(orig);
    }
    return *this;
  }

  friend ostream& operator << (ostream& os, const RankedSolution7<T, S, R, U>& orig) {
    os << orig.first << " " << orig.second << " " << orig.third << " " << orig.fourth; 
    return os;
  }

  friend istream& operator >> (istream& is, RankedSolution7<T, S, R, U>& orig) {
    is >> orig.first >> orig.second >> orig.third >> orig.fourth; 
    return is;
  }

  /* PREDICATES */

  double getFirst() const { return first; }

  const T& getSecond() const { return second; }

  const S& getThird() const { return third; }

  const R& getFourth() const { return fourth; }

  /* MODIFIERS */
  void copy(const RankedSolution7<T, S, R, U>& other) {
    first = other.first;
    second = other.second;
    third = other.third;
    fourth = other.fourth;
    fifth = other.fifth;
  }

  void setFirst(double val) { first = val; }

  void setSecond(const T& val) { second = val; }

  void setThird(const S& val) { third = val; }

  void setFourth(const R& val) { fourth = val; }

  /* ATTRIBUTES */

  double first;
  T second;
  S third;
  R fourth;
  U fifth;

protected:
  /* OPERATORS  */
  /* PREDICATES */
  /* MODIFIERS  */

private:
  /* OPERATORS  */
  /* PREDICATES */
  /* MODIFIERS  */

private:
  /* PRIVATE ATTRIBUTES */

};

/** comparison operator. */
template<class T, class S, class R, class U>
inline
bool operator < (const RankedSolution7<T, S, R, U>& lval,
		 const RankedSolution7<T, S, R, U>& rval) { 
  return lval.first < rval.first;
}

/** comparison operator. */
template<class T, class S, class R, class U>
inline
bool operator < (double lval, const RankedSolution7<T, S, R, U>& rval) {
  return lval < rval.first;
}

/** comparison operator. */
template<class T, class S, class R, class U>
inline
bool operator < (const RankedSolution7<T, S, R, U>& lval, double rval)   {
  return lval.first < rval;
}


#endif /* __ACLASS_H__ */

