#ifndef __GENERAL_NUMERICS__
#define __GENERAL_NUMERICS__

#include <libintl.h>
#include <debug.h>
#include <math.h>

/** Returns log odds, typically the logarithm of a likelihood ratio */
inline
double logOdds(double p) {
  ASSERT((p > 0.0 ) && (p < 1.0));
  return log(p / (1-p));
}

template <class T>
int 
signum(T x)
{
  if (x > 0) {
    return 1;
  }
  else if (x < 0) {
    return -1;
  }
  return 0;
}

double factorial(int n);

double logFactorial(int n);

double nOverK(int n, int k); 

double logNOverK(int n, int k);

double lg2(double x);

/** returns logistic function */
double logistic(double x);

/** delta function */
template <class T>
int 
deltaFunction(const T& x, const T& y)
{
  if (x == y) {
    return 1;
  }
  return 0;
}

/** returns poisson function value */
double poisson(int k, double expected);

/** returns poisson function value */
double poissonCdf(int k, double expected);

/** how likely is it to observe this many or more counts?
 * same as probability as NOT observing less counts */
double poissonCdfP(int k, double expected);


#endif
