#ifndef __REAL_NUMERICS__
#define __REAL_NUMERICS__

#include <debug.h>
#include <Vector3D.h>

inline
double
convexComb(double frac, double a, double b)
{
  return (1.0 - frac) * a +  frac * b;
}

double
interpol(double x, double xmin, double xmax, double ymin, double ymax);

// trilinear interpolation, fancy version
double
interpol(const Vector3D& pos,
	 double dx,
	 double dy,
	 double dz,
	 double y0,
	 double y1, 
	 double y2,
	 double y3,
	 double y1N,
	 double y2N,
	 double y3N);

// trilinear interpolation!
inline
double
interpol(const Vector3D& pos,
	 double dx,
	 double dy,
	 double dz,
	 const Vector3D& pos0,
	 double y0,
	 double y1, 
	 double y2,
	 double y3)
{
  PRECOND((dx > 0.0) && (dy > 0.0) && (dz > 0.0));
  // pos = pos - pos0;
  //    double frac1 = pos.x() / dx; // projection to x axis
  //    double frac2 = pos.y() / dy; // projection to y axis
  //    double frac3 = pos.z() / dz;
  // double result = y0 + convexComb(frac1, 0, y1-y0) + convexComb(frac2, 0, y2-y0) + convexComb(frac3, 0, y3-y0);
  return (y0 + ((pos.x()-pos0.x()) * (y1-y0)/dx)  + ((pos.y()-pos0.y()) * (y2-y0)/dy) + ((pos.z()-pos0.z()) * (y3-y0)/dz));
}

// trilinear interpolation!
double
interpol(Vector3D pos,
	 double y,
	 Vector3D pos0,
	 double y0,
	 Vector3D pos1,
	 double y1, 
	 Vector3D pos2,
	 double y2,
	 Vector3D pos3,
	 double y3);

#endif
