#ifndef __CONTAINER_TOOLS__
#define __CONTAINER_TOOLS__

#include <iostream>
#include <algorithm>
#include <Vec.h>
#include <iterator>

using namespace std;

/** General utility methods for containers. */
class ContainerTools {

 public:

  /** Writes content of container to output stream */
  template <typename _InputIterator>
  static
  void write(ostream& os, _InputIterator _first, _InputIterator _last, const string& sep = " ") {
    for ( ; _first != _last ; _first++) {
      os << (*_first) << sep;
    }
  }

  template<typename _InputIterator>
  static
  bool isSorted(_InputIterator set1Begin, _InputIterator set1End) {
    if (set1Begin == set1End) {
      return true;
    }
    _InputIterator oldIt = set1Begin;
    set1Begin++;
    for (_InputIterator it = set1Begin; it != set1End; it++) {
      if (*it < *oldIt) {
	return false;
      }
      oldIt = it;
    }
    return true;
  }

  /** Returns true, if stricly monotonic increasing (no duplicates) */
  template<typename _InputIterator>
  static
  bool isStrictlySorted(_InputIterator set1Begin, _InputIterator set1End) {
    if (set1Begin == set1End) {
      return true;
    }
    _InputIterator oldIt = set1Begin;
    set1Begin++;
    for (_InputIterator it = set1Begin; it != set1End; it++) {
      if (*it <= *oldIt) {
	return false;
      }
      oldIt = it;
    }
    return true;
  }

  /** Returns intersection between two sets. Much more efficient if set2 is hash set and set1 is as small as possible.
   * _OutConteiner must be class supporting push_back operation. */
  template<typename _InputIterator, typename _Set2, typename _OutContainer>
  static  
  void setIntersection(_InputIterator set1Begin, _InputIterator set1End,
		    const _Set2& set2, _OutContainer& result) {
    for (_InputIterator i = set1Begin; i != set1End; i++) {
      if (set2.find(*i) != set2.end()) {
	// result.insert(*i);
	result.push_back(*i);
      }
    }
  }

  static
  void testSet_intersection() {
    Vec<int> v1;
    Vec<int> v2;
    v1.push_back(1);
    v1.push_back(2);
    v1.push_back(3);
    v1.push_back(4);
    v2.push_back(2);
    v2.push_back(4);
    v2.push_back(6);
    v2.push_back(8);
    Vec<int> v3;
    // v3.push_back(0);
    // v3.push_back(0);
    v3.reserve(v1.size());
    cout << "Starting set_intersection!" << endl;
    set_intersection(v1.begin(), v1.end(), v2.begin(), v2.end(), back_inserter(v3));
    cout << "Finished set_intersection! " << v3 << endl;
    ASSERT(v3.size() == 2);
    ASSERT(v3[0] == 2); 
    ASSERT(v3[1] == 4); 
  }

  /** Returns intersection between two sets. Much more efficient if set2 is hash set and set1 is as small as possible.
   * _OutContainer must be class supporting push_back operation.
   * Stored values are greater or equal minVal. 
   */
  template<typename _InputIterator, typename _Set2, typename _ValueType, typename _OutContainer>
  static  
  void setIntersectionMin(_InputIterator set1Begin, _InputIterator set1End,
			  const _Set2& set2, _ValueType minVal,  _OutContainer& result) {
    for (_InputIterator i = set1Begin; i != set1End; i++) {
      if ((*i >= minVal) && (set2.find(*i) != set2.end())) {
	// result.insert(*i);
	result.push_back(*i);
      }
    } 
  }


  /** Returns intersection between two sets. Much more efficient if set2 is hash set and set1 is as small as possible.
   * _OutContainer must be class supporting push_back operation.
   * Stored values are greater or equal minVal. 
   * Set1Begin can be increased!
   */
  template<typename _InputIterator, typename _Set2, typename _ValueType, typename _OutContainer>
  static  
  void setIntersectionMinFast(_InputIterator& set1Begin, _InputIterator set1End,
			      const _Set2& set2, _ValueType minVal,  _OutContainer& result) {
    for (_InputIterator i = set1Begin; i != set1End; i++) {
      if (*i >= minVal) {
	if (set2.find(*i) != set2.end()) {
	  // result.insert(*i);
	  result.push_back(*i);
	}
      } else {
	set1Begin++; // modify starter position!
      }
    }
  }

};

#endif
