# converts string to RNA complement (not reverse)
nucleotides.complement <- function(s, dna=FALSE, strict="self") {
	len <- nchar(s)
	result <- ""
	for (i in 1:len) {
		result <- paste(result, nucleotide.complement(substr(s, i, i), dna=dna, strict=strict), sep="")
	}
	stopifnot(nchar(result) == nchar(s))
	result
}

test.nucleotides.complement <- function() {
	checkEquals(nucleotides.complement("ACCGGU"), "UGGCCA")
	checkEquals(nucleotides.complement("-ACCGGU"), "-UGGCCA")
	checkEquals(nucleotides.complement("GN"), "CN")
}	

