#!/usr/bin/perl

($mode, $dir, $listfile) = @ARGV;

@lines = <STDIN>;

$intro = ">";

$pc = 0;
$n = scalar(@lines);

if (length($listfile) < 1) {
    $listfile = "/dev/null";
}

open (LIST, ">$listfile"); # write names to output list

while ($pc < $n)
{
    $nameline = $lines[$pc];
    chomp($nameline);
    print "Reading $nameline\n";
    # translate forward slash into underscore:
    $nameline =~ tr/\//_/;
    @words = split/ /,$nameline;
    $testword = substr($words[0],0,1);
    if ($testword ne $intro) {
	print "Strange line: \n $nameline \n";
	print "$testword\n";
	$pc++;
    }
    else {
	$name = substr($words[0],1);
	$name =~ tr/\//\_/; # translate slash with underscore
	$filename = $name . ".fasta";
	if (length($dir) > 0) {
	    $filename = $dir . "/" . $filename; # write into subdirectory
	}
	open(FILE, ">$filename");
	print FILE "$nameline\n";
	print LIST "$name\n";
	$pc++;
	while ( ($pc < $n) && (substr($lines[$pc],0,1) ne ">") )
	{
	    # delete - or . characters:
	    if ($mode eq "d") {
		$lines[$pc] =~ tr/.//d;
		$lines[$pc] =~ tr/-//d;
	    }
	    print FILE $lines[$pc];
	    $pc++;
	}
	close(FILE);
    }
}

close(LIST);
