/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandApplication;
import commandtools.CommandException;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;

class DefinedCommand
extends AbstractCommand {
    private String definedName;
    private String fileName;
    private String helpText;
    private CommandApplication application;

    public DefinedCommand(String definedName, String fileName, String helpText, CommandApplication application) {
        super(definedName);
        this.definedName = definedName;
        this.fileName = fileName;
        this.helpText = helpText;
        this.application = application;
    }

    @Override
    public Object cloneDeep() {
        DefinedCommand command = new DefinedCommand(this.definedName, this.fileName, this.helpText, this.application);
        command.definedName = this.definedName;
        command.fileName = this.fileName;
        command.helpText = this.helpText;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return this.definedName;
    }

    public String helpOutput() {
        return this.helpText;
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        return this.helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.application != null);
        String commandText = "source " + this.fileName;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            commandText = commandText + " " + ((StringParameter)this.getParameter(i)).getValue();
        }
        System.out.println("Issuing command: " + commandText);
        try {
            this.application.runScriptLine(commandText);
        }
        catch (CommandException ce) {
            throw new CommandExecutionException("Error issuing command: " + commandText + " : " + ce.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }
}

