/*
 * Decompiled with CFR 0.152.
 */
package commandtools;

import commandtools.AbstractInterpreter;
import commandtools.AtomicCommand;
import commandtools.BadSyntaxException;
import commandtools.Command;
import commandtools.ForeachCommand;
import commandtools.Interpreter;
import commandtools.InterpreterTools;
import commandtools.StringParameter;
import commandtools.UnknownCommandException;
import generaltools.ParsingException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class LineInterpreter
extends AbstractInterpreter
implements Interpreter {
    public static final char PARAM_DELIMITER = '=';
    public static final String CLOSING_DELIM = "end";

    public LineInterpreter(Logger log) {
        super(log);
    }

    @Override
    public Command interpret(BufferedReader bufReader) throws BadSyntaxException, IOException, UnknownCommandException {
        String line = null;
        do {
            if (bufReader.ready()) continue;
            return null;
        } while ((line = bufReader.readLine()) == null || line.length() == 0);
        log.fine("Interpreting scanned line: " + line);
        Command command = this.interpretLine(line);
        if (command != null && command instanceof ForeachCommand) {
            log.fine("Foreach command detected!");
            ArrayList<String> bodyLinesList = new ArrayList<String>();
            boolean isOk = false;
            int loopCount = 1;
            while (true) {
                if (!bufReader.ready()) {
                    throw new BadSyntaxException("Could not find end statement for the for loop");
                }
                line = bufReader.readLine();
                if (line == null || line.length() == 0) continue;
                line = line.trim();
                log.fine("body line: " + line);
                if (line.indexOf("foreach") == 0) {
                    ++loopCount;
                } else if (line.equals(CLOSING_DELIM)) {
                    --loopCount;
                }
                if (line.equals(CLOSING_DELIM) && loopCount == 0) {
                    String[] bodyLines = new String[bodyLinesList.size()];
                    for (int i = 0; i < bodyLines.length; ++i) {
                        bodyLines[i] = (String)bodyLinesList.get(i);
                    }
                    ForeachCommand foreachCommand = (ForeachCommand)command;
                    assert (bodyLines != null);
                    foreachCommand.setBodyLines(bodyLines);
                    break;
                }
                bodyLinesList.add(line);
                if (isOk) break;
            }
        }
        return command;
    }

    public static StringParameter generateStringParameter(String text) {
        assert (text != null);
        int pos = text.indexOf(61);
        if (pos < 0) {
            return new StringParameter(text);
        }
        String sValue = "";
        if (pos < text.length()) {
            sValue = text.substring(pos + 1);
        }
        String name = "";
        if (pos > 0) {
            name = text.substring(0, pos);
        }
        log.fine("Parameter pair: " + name + " " + sValue + " from: " + text);
        return new StringParameter(sValue, name);
    }

    @Override
    public Command interpretLine(String line) throws BadSyntaxException, UnknownCommandException {
        if (line == null) {
            log.warning("Null line cannot be interpreted!");
            return null;
        }
        log.fine("Interpreting line: " + line);
        try {
            line = InterpreterTools.replaceEnvironmentVariables(line, variables);
        }
        catch (ParsingException pe) {
            throw new BadSyntaxException(pe.getMessage());
        }
        StringTokenizer tokenizer = new StringTokenizer(line);
        if (!tokenizer.hasMoreTokens()) {
            return null;
        }
        String commandName = tokenizer.nextToken();
        Command commandOrig = this.findCommand(commandName);
        if (commandOrig == null) {
            throw new UnknownCommandException("Unknown command: " + commandName);
        }
        log.fine("Found command: " + commandOrig);
        Command command = (Command)commandOrig.cloneDeep();
        if (!(command instanceof AtomicCommand)) {
            while (tokenizer.hasMoreTokens()) {
                String nextToken = tokenizer.nextToken();
                log.fine("Adding parameter (or sub-command): " + nextToken);
                command.addParameter(LineInterpreter.generateStringParameter(nextToken));
            }
        }
        log.fine("Finished interpretLine: " + ((Object)command).toString());
        return command;
    }
}

