/*
 * Decompiled with CFR 0.152.
 */
package generaltools;

import java.io.OutputStream;
import java.io.PrintStream;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.zip.DataFormatException;
import org.testng.annotations.Test;

public class PropertyTools {
    public static final String DELIMITER = ";";

    public static void printProperties(PrintStream ps, Properties properties) {
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            ps.println(key + " = " + properties.getProperty(key));
        }
    }

    public static void printProperties(PrintStream ps, ResourceBundle properties) {
        Enumeration<String> keys = properties.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            ps.println(key + " = " + properties.getString(key));
        }
    }

    public static void mergeProperties(Properties pOrig, Properties pNew, String prefix) {
        if (pNew == null) {
            return;
        }
        if (prefix == null) {
            prefix = "";
        }
        Enumeration<Object> keys = pNew.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            pOrig.setProperty(prefix + key, pNew.getProperty(key));
        }
    }

    public static void merge(Properties pOrig, Properties pNew) {
        if (pNew == null) {
            return;
        }
        Enumeration<Object> keys = pNew.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String newValue = pNew.getProperty(key);
            PropertyTools.addProperty(pOrig, key, newValue);
        }
    }

    public static void addProperty(Properties p, String key, String newValue) {
        assert (p != null);
        String val = p.getProperty(key);
        val = val == null ? new String(newValue) : val + DELIMITER + newValue;
        p.setProperty(key, val);
    }

    public static String[] getIndividualProperties(Properties p, String key) {
        assert (p != null);
        String val = p.getProperty(key);
        if (val == null) {
            return null;
        }
        return val.split(DELIMITER);
    }

    public static Properties generatePropertiesFromSingleParameter(String s) throws ParseException {
        String[] words;
        assert (s != null);
        Properties properties = new Properties();
        for (String word : words = s.split(DELIMITER)) {
            String[] tokens = word.split(":");
            if (tokens.length != 2) {
                throw new ParseException("Excpected colon (:) character in word " + word, 0);
            }
            properties.setProperty(tokens[0], tokens[1]);
        }
        return properties;
    }

    @Test(groups={"new"})
    public void testGeneratePropertiesFromSingleParameter() {
        block5: {
            String s1 = "hey:you;car:jeep";
            try {
                Properties prop1 = PropertyTools.generatePropertiesFromSingleParameter(s1);
                assert ("you".equals(prop1.getProperty("hey")));
                assert ("jeep".equals(prop1.getProperty("car")));
                assert (prop1.size() == 2);
            }
            catch (ParseException pe) {
                System.out.println(pe.getMessage());
                if ($assertionsDisabled) break block5;
                throw new AssertionError();
            }
        }
    }

    public static int parseInt(Properties p, String key) {
        if (p.getProperty(key) == null) {
            return 0;
        }
        return Integer.parseInt(p.getProperty(key));
    }

    public static double parseDouble(Properties p, String key) throws DataFormatException {
        if (p.getProperty(key) == null) {
            throw new DataFormatException("Property " + key + " undefined.");
        }
        return Double.parseDouble(p.getProperty(key));
    }

    public static void plusProperty(Properties p, String key, double value) {
        if (p.getProperty(key) == null) {
            p.setProperty(key, "" + value);
        } else {
            p.setProperty(key, "" + (Double.parseDouble(p.getProperty(key)) + value));
        }
    }

    public static void plusProperty(Properties p, String key, int value) {
        assert (p != null);
        if (p.getProperty(key) == null) {
            p.setProperty(key, "" + value);
        } else {
            p.setProperty(key, "" + (Integer.parseInt(p.getProperty(key)) + value));
        }
    }

    public static void writeToPdbRemarks(OutputStream os, Properties p) {
        PrintStream ps = new PrintStream(os);
        Enumeration<Object> keys = p.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            ps.println("REMARK   " + key + "=" + p.getProperty(key));
        }
    }
}

