/*
 * Decompiled with CFR 0.152.
 */
package graphtools;

import graphtools.IntegerArrayConstraint;
import graphtools.IntegerArrayIncreasingGenerator;
import graphtools.IntegerPermutator;
import graphtools.IntegerPermutatorList;
import graphtools.PermutationGenerator;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class BipartiteGraphPermutator
implements IntegerPermutator {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private IntegerPermutator posGenerator;
    private IntegerPermutator valueGenerator;
    private IntegerPermutatorList permutatorList;
    private List<IntegerArrayConstraint> constraints = new ArrayList<IntegerArrayConstraint>();
    private int toLen;
    private int numConn;
    private boolean uptodate = false;

    public BipartiteGraphPermutator(int toLen, int numConn) {
        assert (numConn > 0);
        assert (toLen >= 2 * numConn);
        this.numConn = numConn;
        this.toLen = toLen;
        this.posGenerator = new IntegerArrayIncreasingGenerator(2 * numConn, toLen);
        this.valueGenerator = new PermutationGenerator(2 * numConn);
        this.permutatorList = new IntegerPermutatorList();
        this.permutatorList.add(this.posGenerator);
        this.permutatorList.add(this.valueGenerator);
        this.reset();
        assert (this.validate());
    }

    @Override
    public void addConstraint(IntegerArrayConstraint constraint) {
        assert (false);
        this.constraints.add(constraint);
        this.reset();
        assert (this.validate());
    }

    @Override
    public Object clone() {
        throw new RuntimeException("clone method not supported.");
    }

    @Override
    public BigInteger getTotal() {
        return this.permutatorList.getTotal();
    }

    @Override
    public boolean hasNext() {
        return this.permutatorList.hasNext();
    }

    @Override
    public boolean inc() {
        assert (this.hasNext());
        do {
            this.permutatorList.inc();
        } while (this.permutatorList.hasNext() && !this.validate());
        return this.validate();
    }

    private void printVec(PrintStream ps, int[] positions) {
        for (int i = 0; i < positions.length; ++i) {
            ps.print(" " + positions[i]);
        }
        ps.println();
    }

    @Override
    public int[] get() {
        int[] values = this.valueGenerator.get();
        int[] result = new int[values.length];
        int[] positions = this.posGenerator.get();
        assert (values.length == positions.length);
        for (int i = 0; i < result.length; ++i) {
            assert (values[i] < positions.length);
            result[i] = positions[values[i]];
        }
        return result;
    }

    @Override
    public int[] next() {
        this.inc();
        return this.get();
    }

    @Override
    public void reset() {
        System.out.println("Starting reset");
        this.posGenerator.reset();
        this.valueGenerator.reset();
        this.permutatorList.reset();
        while (!this.validate() && this.hasNext()) {
            System.out.println("Increasing vector ");
            this.printVec(System.out, this.get());
            this.inc();
        }
        System.out.println("Finished reset:");
        this.printVec(System.out, this.get());
        assert (this.validate());
    }

    @Override
    public int size() {
        return 2 * this.numConn;
    }

    @Override
    public boolean validate() {
        int i;
        int[] data = this.get();
        for (i = 0; i < this.numConn; ++i) {
            if (data[2 * i] < data[2 * i + 1]) continue;
            return false;
        }
        for (i = 1; i < this.numConn; ++i) {
            if (data[2 * i] > data[2 * (i - 1)]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        int[] result = this.get();
        if (result == null) {
            return "null";
        }
        String s = "";
        for (int i = 0; i < result.length; ++i) {
            s = s + result[i] + " ";
        }
        return s;
    }
}

