/*
 * Decompiled with CFR 0.152.
 */
package graphtools;

import generaltools.Randomizer;
import graphtools.DnaJunction;
import graphtools.PermutationGenerator;
import java.util.Random;
import java.util.logging.Logger;

public class DnaJunctionImp
implements DnaJunction {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private int[] permutation;
    private int permutationId;
    private PermutationGenerator permGenerator;
    private static Random rnd = Randomizer.getInstance();

    public DnaJunctionImp(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("Minimum argument for DnaJunctionImp(n): 2");
        }
        this.permGenerator = new PermutationGenerator(n - 1);
        this.reset();
    }

    @Override
    public int getEdgeCount() {
        return this.permutation.length + 1;
    }

    @Override
    public int get5PrimeConnection(int n) {
        if (n == this.permutation.length) {
            return this.permutation[0];
        }
        for (int i = 0; i < this.permutation.length; ++i) {
            if (this.permutation[i] != n) continue;
            if (i + 1 < this.permutation.length) {
                return this.permutation[i + 1];
            }
            return this.permutation.length;
        }
        log.warning("Could not find " + n + " " + this.toString());
        return this.permutation[-1];
    }

    @Override
    public int get3PrimeConnection(int n) {
        if (n == this.permutation.length) {
            return this.permutation[this.permutation.length - 1];
        }
        for (int i = 0; i < this.permutation.length; ++i) {
            if (this.permutation[i] != n) continue;
            if (i > 0) {
                return this.permutation[i - 1];
            }
            return this.permutation.length;
        }
        log.warning("Could not find " + n + " " + this.toString());
        return this.permutation[-1];
    }

    public int[] getPermutation() {
        return this.permutation;
    }

    @Override
    public boolean hasNext() {
        return this.permGenerator.hasMore();
    }

    @Override
    public int getPermutationId() {
        return this.permutationId;
    }

    @Override
    public void next() {
        this.permutation = this.permGenerator.getNext();
        ++this.permutationId;
    }

    @Override
    public int permutationCount() {
        return this.permGenerator.getTotal().intValue();
    }

    @Override
    public void reset() {
        this.permGenerator.reset();
        this.permutation = this.permGenerator.getNext();
        this.permutationId = 0;
    }

    @Override
    public void setRandom() {
        int r = rnd.nextInt(this.permutationCount());
        this.reset();
        for (int i = 0; i < r; ++i) {
            this.next();
        }
    }

    public String toString() {
        String result = "";
        result = result + this.permGenerator.size() + " " + this.permutationId + " " + this.hasNext();
        return result;
    }
}

