/*
 * Decompiled with CFR 0.152.
 */
package graphtools;

import generaltools.TestTools;
import graphtools.IntegerArrayConstraint;
import graphtools.IntegerArraySumConstraint;
import graphtools.IntegerPermutator;
import graphtools.IntegerPermutatorTools;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.testng.annotations.Test;

public class IntegerArrayIncreasingGenerator
implements IntegerPermutator {
    private int[] numbers;
    private int base;
    private List<IntegerArrayConstraint> constraints = new ArrayList<IntegerArrayConstraint>();
    private boolean initial = false;
    private BigInteger total;

    public IntegerArrayIncreasingGenerator() {
        this(1, 1);
    }

    public IntegerArrayIncreasingGenerator(int length, int base) {
        assert (length > 0);
        assert (base > 0);
        assert (base >= length);
        this.numbers = new int[length];
        this.base = base;
        this.reset();
        assert (this.numbers.length == length);
        assert (this.validate());
    }

    @Override
    public void addConstraint(IntegerArrayConstraint constraint) {
        this.constraints.add(constraint);
        this.reset();
        assert (this.validate());
    }

    @Override
    public Object clone() {
        throw new RuntimeException("clone method not supported.");
    }

    private void printVec(PrintStream ps, int[] x) {
        for (int n : x) {
            ps.print("" + n + " ");
        }
    }

    private BigInteger getTotal(int len, int max) {
        assert (len > 0);
        assert (max >= len);
        if (len == 1) {
            assert (max >= 1);
            BigInteger result = new BigInteger("" + max);
            return result;
        }
        BigInteger result = new BigInteger("0");
        int newLen = len - 1;
        for (int newMax = max - 1; newMax >= newLen; --newMax) {
            result = result.add(this.getTotal(newLen, newMax));
        }
        return result;
    }

    @Override
    public BigInteger getTotal() {
        if (this.total != null) {
            return this.total;
        }
        this.total = this.getTotal(this.numbers.length, this.base);
        return this.total;
    }

    @Test(groups={"new"})
    public void testGetTotal() {
        String methodName = "IntegerArrayIncreasingGenerator.testGetTotal";
        System.out.println(TestTools.generateMethodHeader(methodName));
        IntegerArrayIncreasingGenerator gen = new IntegerArrayIncreasingGenerator(2, 3);
        BigInteger expected = new BigDecimal("3").toBigInteger();
        BigInteger firstCount = gen.getTotal();
        long count = 0L;
        do {
            System.out.println("" + ++count + " : " + gen);
            assert (gen.getTotal().equals(firstCount));
        } while (gen.hasNext() && gen.inc());
        System.out.println("Expected this many iterations: " + expected + " computed total: " + firstCount + " " + gen.getTotal());
        assert (gen.getTotal().equals(expected));
        System.out.println(TestTools.generateMethodHeader(methodName));
    }

    public void testGetTotal(int len, int b) {
        IntegerArrayIncreasingGenerator gen = new IntegerArrayIncreasingGenerator(len, b);
        BigInteger firstCount = gen.getTotal();
        long count = 0L;
        do {
            System.out.println("" + ++count + " : " + gen);
            assert (gen.getTotal().equals(firstCount));
        } while (gen.hasNext() && gen.inc());
        System.out.println("Expected this many iterations: computed total: " + firstCount + " " + gen.getTotal());
    }

    @Test(groups={"new"})
    public void testGetTotal3_4() {
        String methodName = "IntegerArrayIncreasingGenerator.testGetTotal";
        System.out.println(TestTools.generateMethodHeader(methodName));
        this.testGetTotal(3, 4);
        System.out.println(TestTools.generateMethodHeader(methodName));
    }

    @Override
    public boolean hasNext() {
        for (int i = 1; i < this.numbers.length; ++i) {
            if (this.numbers[i - 1] + 1 >= this.numbers[i]) continue;
            return true;
        }
        return this.numbers[this.numbers.length - 1] + 1 < this.base;
    }

    @Override
    public boolean inc() {
        assert (this.hasNext());
        while (this.hasNext()) {
            int pc = 0;
            while (pc < this.numbers.length) {
                if (pc + 1 < this.numbers.length) {
                    if (this.numbers[pc] + 1 >= this.numbers[pc + 1]) {
                        this.numbers[pc] = 0;
                        ++pc;
                        continue;
                    }
                    int n = pc;
                    this.numbers[n] = this.numbers[n] + 1;
                    return true;
                }
                if (this.numbers[pc] + 1 >= this.base) {
                    assert (false);
                    continue;
                }
                int n = pc;
                this.numbers[n] = this.numbers[n] + 1;
                return true;
            }
            if (!this.validate()) continue;
            return true;
        }
        return false;
    }

    public int[] getNumbers() {
        return this.numbers;
    }

    @Override
    public int[] get() {
        if (!this.validate()) {
            System.out.println("IntegerArrayIncreasingGenerator: Numbers do not validate: ");
            this.printVec(System.out, this.numbers);
            return null;
        }
        return this.numbers;
    }

    @Override
    public int[] next() {
        boolean check = this.inc();
        if (!check) {
            return null;
        }
        return this.numbers;
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.numbers.length; ++i) {
            assert (i < this.base);
            this.numbers[i] = i;
        }
        while (!this.validate() && this.hasNext()) {
            System.out.println("IntegerArrayGenerator.result: Sofar could not find validating reset position:");
            this.printVec(System.out, this.numbers);
            this.inc();
        }
        if (!this.validate()) {
            System.out.println("Could not find validating reset position:");
            this.printVec(System.out, this.numbers);
            assert (false);
        }
    }

    @Override
    public int size() {
        return this.numbers.length;
    }

    public long totalNumber() {
        assert (this.base >= this.numbers.length);
        long result = 1L;
        for (int i = 0; i < this.numbers.length; ++i) {
            assert (this.base > i);
            result *= (long)(this.base - i);
        }
        return result;
    }

    @Override
    public boolean validate() {
        if (this.numbers.length == 0 && this.numbers[0] < this.base && this.numbers[0] >= 0) {
            return true;
        }
        for (int i = 1; i < this.numbers.length; ++i) {
            if (this.numbers[i - 1] >= this.numbers[i]) {
                return false;
            }
            if (this.numbers[i] >= 0) continue;
            return false;
        }
        String s = this.toString();
        if (s == null || s.equals("null")) {
            return false;
        }
        for (IntegerArrayConstraint constraint : this.constraints) {
            if (constraint.validate(this.numbers)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.numbers.length; ++i) {
            buf.append("" + this.numbers[i] + " ");
        }
        return buf.toString();
    }

    @Test(groups={"new"})
    public void testIntegerArrayIncreasingGenerator() {
        String methodName = "testIntegerArrayIncreasingGenerator";
        System.out.println(TestTools.generateMethodHeader(methodName));
        IntegerArrayIncreasingGenerator gen = new IntegerArrayIncreasingGenerator(2, 3);
        int count = 0;
        System.out.println("Results of integer Array generator");
        do {
            int[] x = gen.get();
            assert (x != null);
            this.printVec(System.out, x);
            System.out.println();
            ++count;
        } while (gen.hasNext() && gen.next() != null);
        System.out.println("gen has no successor: " + gen);
        assert (count == 3);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    @Test(groups={"new"})
    public void testIntegerArrayIncreasingGenerator2() {
        String methodName = "testIntegerArrayIncreasingGenerator2";
        System.out.println(TestTools.generateMethodHeader(methodName));
        IntegerArrayIncreasingGenerator gen = new IntegerArrayIncreasingGenerator(4, 4);
        int count = 0;
        System.out.println("Results of integer Array generator");
        do {
            int[] x = gen.get();
            assert (x != null);
            this.printVec(System.out, x);
            System.out.println();
            ++count;
        } while (gen.hasNext() && gen.next() != null);
        System.out.println("gen has no successor: " + gen);
        assert (count == 1);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    private int computeSum(int[] a) {
        int s = 0;
        for (int i = 0; i < a.length; ++i) {
            s += a[i];
        }
        return s;
    }

    @Test(groups={"new"})
    public void testIntegerArrayIncreasingGenerator4() {
        String methodName = "testIntegerArrayIncreasingGenerator4";
        System.out.println(TestTools.generateMethodHeader(methodName));
        int sum = 6;
        IntegerArrayIncreasingGenerator gen = new IntegerArrayIncreasingGenerator(3, 4);
        gen.addConstraint(new IntegerArraySumConstraint(sum));
        int count = 0;
        System.out.println("Results of integer Array generator, sum must always be " + sum);
        while (gen.hasNext()) {
            ++count;
            int[] x = gen.next();
            if (x == null) {
                System.out.println("Could not generate further solutions! Quitting loop.");
                break;
            }
            System.out.print("" + count + " : ");
            int computedSum = this.computeSum(x);
            this.printVec(System.out, x);
            System.out.print(" sum: " + computedSum);
            assert (computedSum == sum);
            System.out.println();
        }
        System.out.println("gen has no successor: " + gen);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }

    @Test(groups={"new"})
    public void testIntegerArrayIncreasingGenerator5() {
        String methodName = "testIntegerArrayIncreasingGenerator5";
        System.out.println(TestTools.generateMethodHeader(methodName));
        IntegerArrayIncreasingGenerator gen = new IntegerArrayIncreasingGenerator(4, 6);
        int n = IntegerPermutatorTools.testIntegerPermutatorRunToEnd(gen);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }
}

