/*
 * Decompiled with CFR 0.152.
 */
package graphtools;

import generaltools.TestTools;
import graphtools.IntegerArrayConstraint;
import graphtools.IntegerPermutator;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.testng.annotations.Test;

public class PermutationGenerator
implements IntegerPermutator {
    private int[] a;
    private BigInteger numLeft;
    private BigInteger total;
    private List<IntegerArrayConstraint> constraints = new ArrayList<IntegerArrayConstraint>();

    public PermutationGenerator() {
        this(1);
    }

    public PermutationGenerator(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Minimum argument for PermutationGenerator: 1");
        }
        this.a = new int[n];
        this.total = PermutationGenerator.getFactorial(n);
        this.reset();
    }

    @Override
    public void addConstraint(IntegerArrayConstraint constraint) {
        this.constraints.add(constraint);
    }

    @Override
    public Object clone() {
        throw new RuntimeException("clone method not supported.");
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i] = i;
        }
        this.numLeft = new BigInteger(this.total.toString());
        this.next();
    }

    public BigInteger getNumLeft() {
        return this.numLeft;
    }

    @Override
    public BigInteger getTotal() {
        return this.total;
    }

    @Override
    public boolean hasNext() {
        return this.hasMore();
    }

    public boolean hasMore() {
        return this.numLeft.compareTo(BigInteger.ZERO) == 1;
    }

    private static BigInteger getFactorial(int n) {
        BigInteger fact = BigInteger.ONE;
        for (int i = n; i > 1; --i) {
            fact = fact.multiply(new BigInteger(Integer.toString(i)));
        }
        return fact;
    }

    @Override
    public int[] next() {
        return this.getNext();
    }

    @Override
    public int[] get() {
        return this.a;
    }

    @Override
    public boolean inc() {
        while (this.hasNext()) {
            if (this.numLeft.equals(this.total)) {
                this.numLeft = this.numLeft.subtract(BigInteger.ONE);
                if (!this.validate()) continue;
                return true;
            }
            int j = this.a.length - 2;
            while (this.a[j] > this.a[j + 1]) {
                --j;
            }
            int k = this.a.length - 1;
            while (this.a[j] > this.a[k]) {
                --k;
            }
            int temp = this.a[k];
            this.a[k] = this.a[j];
            this.a[j] = temp;
            int r = this.a.length - 1;
            for (int s = j + 1; r > s; --r, ++s) {
                temp = this.a[s];
                this.a[s] = this.a[r];
                this.a[r] = temp;
            }
            this.numLeft = this.numLeft.subtract(BigInteger.ONE);
            if (!this.validate()) continue;
            return true;
        }
        assert (!this.hasNext());
        this.reset();
        return false;
    }

    public int[] getNext() {
        this.inc();
        return this.a;
    }

    @Override
    public int size() {
        return this.a.length;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int n : this.a) {
            buf.append("" + n + " ");
        }
        return buf.toString();
    }

    @Override
    public boolean validate() {
        boolean check1;
        boolean bl = check1 = this.a != null && this.a.length > 0;
        if (!check1) {
            return false;
        }
        for (IntegerArrayConstraint constraint : this.constraints) {
            if (constraint.validate(this.get())) continue;
            return false;
        }
        return true;
    }

    @Test(groups={"new"})
    public void testPermutationGeneratorBasics() {
        String methodName = "testPermutationGeneratorBasics";
        System.out.println(TestTools.generateMethodHeader(methodName));
        PermutationGenerator pg = new PermutationGenerator(3);
        int count = 0;
        do {
            int[] a = pg.get();
            System.out.print("" + ++count + " : ");
            for (int n : a) {
                System.out.print("" + n + " ");
            }
            System.out.println();
        } while (pg.hasNext() && pg.inc());
        assert (count == 6);
        System.out.println(TestTools.generateMethodFooter(methodName));
    }
}

