/*
 * Decompiled with CFR 0.152.
 */
package launchtools;

import generaltools.ApplicationBugException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import launchtools.Job;
import launchtools.JobImp;
import launchtools.Queue;
import launchtools.QueueManager;
import launchtools.QueueManagerChangeEvent;
import launchtools.QueueManagerChangeListener;
import launchtools.QueueManagerStatus;
import launchtools.QueuePolicy;
import launchtools.QueueStatus;
import launchtools.RunCommand;
import launchtools.SimpleQueueManagerStatus;
import launchtools.SimpleQueuePolicy;
import launchtools.SimpleRunCommand;
import launchtools.SingleQueue;
import launchtools.UnknownJobException;
import launchtools.UnknownQueueException;

public class SimpleQueueManager
implements QueueManager {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private Map<String, Queue> queueNames = new HashMap<String, Queue>();
    private List<Queue> queues = new ArrayList<Queue>();
    private Map jobs = new HashMap();
    private static final String defaultQueueName = "default";
    private List<QueueManagerChangeListener> changeListeners = new ArrayList<QueueManagerChangeListener>();
    private static SimpleQueueManager instance = null;
    private int jobIdCounter = 1;

    private SimpleQueueManager() {
        this.generateQueue(defaultQueueName, new SimpleQueuePolicy());
    }

    public static synchronized SimpleQueueManager getInstance() {
        if (instance == null) {
            instance = new SimpleQueueManager();
        }
        return instance;
    }

    @Override
    public void addQueueManagerChangeListener(QueueManagerChangeListener listener) {
        this.changeListeners.add(listener);
    }

    @Override
    public synchronized Job createJob(RunCommand command) {
        int jobId = this.generateNewJobId();
        JobImp job = new JobImp(command);
        job.setJobId(jobId);
        return job;
    }

    @Override
    public void fireChangeEvent(QueueManagerChangeEvent event) {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            QueueManagerChangeListener listener = this.changeListeners.get(i);
            listener.statusChanged(event);
        }
    }

    @Override
    public QueueManagerStatus getStatus() {
        return new SimpleQueueManagerStatus(this);
    }

    @Override
    public boolean generateQueue(String queueName, QueuePolicy policy) {
        SingleQueue queue = new SingleQueue(policy);
        queue.setName(queueName);
        this.queueNames.put(queueName, queue);
        this.queues.add(queue);
        return true;
    }

    @Override
    public Job getJobStatus(int jobId) throws UnknownJobException {
        Job job = (Job)this.jobs.get(new Integer(jobId));
        if (job == null) {
            throw new UnknownJobException();
        }
        return job;
    }

    @Override
    public int getNumberQueues() {
        return this.queues.size();
    }

    public Queue getQueue(String name) throws UnknownQueueException {
        Queue queue = this.queueNames.get(name);
        if (queue == null) {
            throw new UnknownQueueException();
        }
        return queue;
    }

    public Queue getQueue(int n) {
        return this.queues.get(n);
    }

    public Queue getQueue() {
        Queue queue = null;
        try {
            queue = this.getQueue(defaultQueueName);
        }
        catch (UnknownQueueException e) {
            throw new ApplicationBugException("Could not find default queue: default");
        }
        return queue;
    }

    @Override
    public String getQueueName(int n) throws IndexOutOfBoundsException {
        return this.getQueue(n).getName();
    }

    @Override
    public QueueStatus getQueueStatus(String queueName) throws UnknownQueueException {
        Queue queue = this.getQueue(queueName);
        return queue.getStatus();
    }

    @Override
    public void deleteJob(int jobId) throws UnknownJobException {
        Queue queue = this.findJobQueue(jobId);
        queue.deleteJob(jobId);
    }

    private Queue findJobQueue(int jobId) throws UnknownJobException {
        return this.getQueue();
    }

    private void registerJob(Job job, Queue queue) {
    }

    @Override
    public synchronized void submit(Job job) {
        Queue queue = this.getQueue();
        this.submit(job, queue);
    }

    public static synchronized List<String> shell(String shellCommand) {
        SimpleQueueManager queueManager = SimpleQueueManager.getInstance();
        String[] commandWords = shellCommand.split(" ");
        SimpleRunCommand command = new SimpleRunCommand(commandWords);
        Job job = queueManager.createJob(command);
        queueManager.submit(job);
        List<String> lines = job.getRunInfo().getLines();
        return lines;
    }

    @Override
    public synchronized int generateNewJobId() {
        return ++this.jobIdCounter;
    }

    @Override
    public synchronized void submit(Job job, String queueName) throws UnknownQueueException {
        Queue queue = this.getQueue(queueName);
        this.submit(job, queue);
    }

    private synchronized void submit(Job job, Queue queue) {
        log.fine("Submitted job: " + job.getJobId() + " " + job.getCommand() + " to queue " + queue.getName());
        this.registerJob(job, queue);
        queue.submit(job);
    }

    @Override
    public void resumeJob(int jobId) throws UnknownJobException {
        Queue queue = this.findJobQueue(jobId);
        queue.resumeJob(jobId);
    }

    @Override
    public void suspendJob(int jobId) throws UnknownJobException {
        Queue queue = this.findJobQueue(jobId);
        queue.suspendJob(jobId);
    }
}

