/*
 * Decompiled with CFR 0.152.
 */
package numerictools;

public class IntervalInt {
    private int lower;
    private int upper;

    public IntervalInt() {
        this.lower = 0;
        this.upper = -1;
    }

    public IntervalInt(int _lower, int _upper) {
        this.lower = _lower;
        this.upper = _upper;
    }

    public IntervalInt(IntervalInt orig) {
        this.copy(orig);
    }

    public int getLength() {
        if (!this.isValid()) {
            return 0;
        }
        return this.getUpper() - this.getLower() + 1;
    }

    public int getLower() {
        return this.lower;
    }

    public int getUpper() {
        return this.upper;
    }

    public double getMiddle() {
        return 0.5 * (double)(this.getLower() + this.getUpper());
    }

    public boolean isOverlapping(IntervalInt other) {
        return this.getUpper() >= other.getLower() && other.getUpper() >= this.getLower();
    }

    public boolean isValid() {
        return this.getUpper() >= this.getLower();
    }

    public void consolidate(IntervalInt other) {
        if (other.getLower() < this.lower) {
            this.lower = other.getLower();
        }
        if (other.getUpper() > this.upper) {
            this.upper = other.getUpper();
        }
    }

    public void setLower(int n) {
        this.lower = n;
    }

    public void setUpper(int m) {
        this.upper = m;
    }

    public void copy(IntervalInt other) {
        this.lower = other.lower;
        this.upper = other.upper;
    }

    public String toString() {
        return "" + this.getLower() + " - " + this.getUpper();
    }
}

