/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class AddBasePairCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "genbpconstraint";
    private Object3DGraphController controller;
    private String name1;
    private String name2;
    private String interactionName;
    private int length = 1;
    private int symId1 = 0;
    private int symId2 = 0;

    public AddBasePairCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        AddBasePairCommand command = new AddBasePairCommand(this.controller);
        command.name1 = this.name1;
        command.name2 = this.name2;
        command.interactionName = this.interactionName;
        command.length = this.length;
        command.symId1 = this.symId1;
        command.symId2 = this.symId2;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: genbpconstraint nucleotide1 nucleotide2 [wc [length]]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"genbpconstraint\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " ORIGINALNAME nucleotide1 nucleotide2 [length]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Adds a base pair between two residues." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            int interactionId = 1;
            for (int offset = 0; offset < this.length; ++offset) {
                this.controller.addBasePair(this.name1, this.name2, interactionId, offset, this.symId1, this.symId2);
            }
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() < 2 || this.getParameterCount() > 4) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        this.name1 = p0.getValue();
        StringParameter p1 = (StringParameter)this.getParameter(1);
        this.name2 = p1.getValue();
        if (this.getParameterCount() > 2) {
            StringParameter p2 = (StringParameter)this.getParameter(2);
            this.length = Integer.parseInt(p2.getValue());
        }
        try {
            StringParameter p = (StringParameter)this.getParameter("sym1");
            if (p != null) {
                this.symId1 = Integer.parseInt(p.getValue());
            }
            if ((p = (StringParameter)this.getParameter("sym2")) != null) {
                this.symId2 = Integer.parseInt(p.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException(nfe.getMessage());
        }
    }
}

