/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.StringTools;
import java.util.ArrayList;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.SimpleObject3DSet;

public class AlignResiduesCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "align";
    private Object3DGraphController controller;
    private String residueDescriptor1;
    private String residueDescriptor2;
    private Object3DSet objectBlocks1;
    private Object3DSet objectBlocks2;
    private int numberSteps = 1000000;
    private String[] atomNames = new String[]{"C4*", "C1*", "O3*"};

    public AlignResiduesCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        AlignResiduesCommand command = new AlignResiduesCommand(this.controller);
        command.controller = this.controller;
        command.numberSteps = this.numberSteps;
        command.objectBlocks1 = this.objectBlocks1;
        command.objectBlocks2 = this.objectBlocks2;
        command.residueDescriptor1 = this.residueDescriptor1;
        command.residueDescriptor2 = this.residueDescriptor2;
        command.atomNames = this.atomNames;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String synopsis() {
        return "align RES-DESCRIPTOR1 RES-DESCRIPTOR2 ROOT1 ROOT2 . Example: align A:3-8 B:1-6 root.structure1 root.structure2 [steps=NUMBER]";
    }

    private String helpOutput() {
        return "Aligns second set of specified residues onto first set of residues. Correct usage: " + this.synopsis();
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"align\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.synopsis() + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Aligns two sets of residues such that the root mean square deviation is minimal" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        return helpText;
    }

    private static boolean isSinglePositionString(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isDigit(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    Object3DSet parseObjectBlocks(String blocks) throws CommandExecutionException {
        if (blocks == null || blocks.length() == 0) {
            throw new CommandExecutionException("blocks option has to be defined! See usage.");
        }
        ArrayList<SimpleObject3DSet> result = new ArrayList<SimpleObject3DSet>();
        String[] setWords = blocks.split(";");
        for (int i = 0; i < setWords.length; ++i) {
            String[] objWords = setWords[i].split(",");
            if (objWords.length < 1) {
                throw new CommandExecutionException("Error in optbasepairs: expected at least one object in " + setWords[i]);
            }
            SimpleObject3DSet set = new SimpleObject3DSet();
            for (int j = 0; j < objWords.length; ++j) {
                String objName = objWords[j];
                Object3D obj = this.controller.getGraph().findByFullName(objName);
                if (obj == null) {
                    throw new CommandExecutionException("Could not find object with name: " + objName);
                }
                set.add(obj);
            }
            result.add(set);
        }
        if (result.size() != 1) {
            throw new CommandExecutionException("Expected comma separated list of tree nodes as one object block!");
        }
        return (Object3DSet)result.get(0);
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        if (this.objectBlocks1 == null || this.objectBlocks1.size() == 0) {
            throw new CommandExecutionException("No object blocks (1) defined!");
        }
        if (this.objectBlocks2 == null || this.objectBlocks2.size() == 0) {
            throw new CommandExecutionException("No object blocks (2) defined!");
        }
        try {
            System.out.println("Aligning residues with atoms: " + StringTools.paste(this.atomNames, ","));
            this.resultProperties = this.controller.alignStructures(this.objectBlocks1, this.objectBlocks2, this.residueDescriptor1, this.residueDescriptor2, this.atomNames, this.numberSteps);
            System.out.println(this.resultProperties);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        int numPar = this.getParameterCount();
        if (numPar < 4) {
            throw new CommandExecutionException("Insufficient number of parameters: " + this.helpOutput());
        }
        this.residueDescriptor1 = ((StringParameter)this.getParameter(0)).getValue();
        this.residueDescriptor2 = ((StringParameter)this.getParameter(1)).getValue();
        this.objectBlocks1 = this.parseObjectBlocks(((StringParameter)this.getParameter(2)).getValue());
        this.objectBlocks2 = this.parseObjectBlocks(((StringParameter)this.getParameter(3)).getValue());
        StringParameter p = (StringParameter)this.getParameter("steps");
        if (p != null) {
            try {
                this.numberSteps = Integer.parseInt(p.getValue());
            }
            catch (NumberFormatException nfe) {
                throw new CommandExecutionException("Error parsing number of stems in align command: " + nfe.getMessage());
            }
        }
        if ((p = (StringParameter)this.getParameter("atoms")) != null) {
            this.atomNames = p.getValue().split(",");
        }
    }
}

