/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.ParsingException;
import java.io.FileOutputStream;
import java.io.IOException;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import rnadesign.rnamodel.AbstractPdbWriter;
import rnadesign.rnamodel.AmberPdbWriter;
import rnadesign.rnamodel.GeneralPdbWriter;
import tools3d.objects3d.ForbiddenObject3DTester;
import tools3d.objects3d.Object3DSet;

public class ExportPdbCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "exportpdb";
    private String fileName;
    private boolean helicesMode = true;
    private boolean junctionMode = true;
    private int renameMode = 2;
    private String variant = "default";
    private Object3DGraphController controller;
    private String[] subtreeNames = null;

    public ExportPdbCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        ExportPdbCommand command = new ExportPdbCommand(this.controller);
        command.fileName = this.fileName;
        command.helicesMode = this.helicesMode;
        command.junctionMode = this.junctionMode;
        command.renameMode = this.renameMode;
        command.variant = this.variant;
        command.subtreeNames = this.subtreeNames;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    public String helpOutput() {
        return "Correct usage: exportpdb FILENAME [renumber=count|name|pdb] [helices=true|false] [junction=false|true] [name=subtree1[,subtree2[,...]]][variant=default|amber";
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"exportpdb\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     exportpdb" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.helpOutput() + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     The command writes a file in PDB format with atom coordinates.";
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        try {
            Object3DSet helixStrands;
            if (!this.fileName.endsWith(".pdb")) {
                this.fileName = this.fileName + ".pdb";
            }
            FileOutputStream fos = new FileOutputStream(this.fileName);
            boolean format = false;
            AbstractPdbWriter writer = null;
            if (this.variant.equals("default")) {
                writer = new GeneralPdbWriter();
            } else if (this.variant.equals("amber")) {
                writer = new AmberPdbWriter();
            }
            writer.setOriginalMode(this.renameMode);
            writer.setJunctionMode(this.junctionMode);
            if (!this.helicesMode && (helixStrands = this.controller.findPureHelicalStrands()).size() > 0) {
                log.info("Exporting PDB structure ignoring " + helixStrands.size() + " helical strands.");
                ForbiddenObject3DTester helixTester = new ForbiddenObject3DTester(helixStrands.getAsList());
                writer.setObjectTester(helixTester);
            }
            this.controller.write(fos, writer, this.subtreeNames);
        }
        catch (IOException exc) {
            throw new CommandExecutionException("Error opening file " + this.fileName);
        }
        catch (Object3DGraphControllerException ex) {
            throw new CommandExecutionException("Controller error in exportpdb command: " + ex.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter variantParameter;
        if (this.getParameterCount() < 1) {
            throw new CommandExecutionException(this.helpOutput());
        }
        assert (this.getParameter(0) instanceof StringParameter);
        try {
            StringParameter helicesParameter;
            StringParameter junctionParameter;
            String renumberString;
            StringParameter stringParameter = (StringParameter)this.getParameter(0);
            this.fileName = stringParameter.getValue();
            StringParameter renumberParameter = (StringParameter)this.getParameter("renumber");
            if (renumberParameter != null && (renumberString = renumberParameter.getValue()) != null) {
                if (renumberString.equals("pdb")) {
                    this.renameMode = 1;
                } else if (renumberString.equals("count")) {
                    this.renameMode = 2;
                } else if (renumberString.equals("name")) {
                    this.renameMode = 3;
                } else {
                    throw new CommandExecutionException("Unknown value of parameter renumber! Allowed: pdb|count|name");
                }
            }
            if ((junctionParameter = (StringParameter)this.getParameter("junction")) != null) {
                this.junctionMode = junctionParameter.parseBoolean();
            }
            if ((helicesParameter = (StringParameter)this.getParameter("helices")) != null) {
                this.helicesMode = helicesParameter.parseBoolean();
            }
        }
        catch (ParsingException pe) {
            throw new CommandExecutionException(pe.getMessage());
        }
        StringParameter nameParameter = (StringParameter)this.getParameter("name");
        if (nameParameter != null) {
            this.subtreeNames = nameParameter.getValue().split(",");
        }
        if ((variantParameter = (StringParameter)this.getParameter("variant")) != null) {
            this.variant = variantParameter.getValue();
        }
    }
}

