/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import generaltools.ParsingException;
import generaltools.PropertyTools;
import java.util.Properties;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class FuseAllStrandsCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "fuseallstrands";
    private Object3DGraphController controller;
    private String root = "root";
    private String resultRoot = "root";
    private String name = "fused";
    private double bridgeRms = 3.0;
    private double cutoff = 5.0;
    private int lengthMin = 1;
    private int lengthMax = 5;
    private boolean stepMode = false;

    public FuseAllStrandsCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        FuseAllStrandsCommand command = new FuseAllStrandsCommand(this.controller);
        command.root = this.root;
        command.resultRoot = this.resultRoot;
        command.name = this.name;
        command.bridgeRms = this.bridgeRms;
        command.cutoff = this.cutoff;
        command.lengthMin = this.lengthMin;
        command.lengthMax = this.lengthMax;
        command.stepMode = this.stepMode;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Fuses strands corresponding to a ring with as high symmetry as possible. Correct usage: fuseallstrands [cutoff=VALUE][max=LENGTH][min=LENGTH][name=RESULTNAME][root=RESULTSUBTREENAME][rms=VALUE][step=false|true]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"fuseallstrands\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + this.helpOutput();
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            if (this.stepMode) {
                Properties properties = this.controller.fuseClosestStrands(this.root, this.name, this.resultRoot, this.cutoff, this.bridgeRms, this.lengthMin, this.lengthMax);
                PropertyTools.printProperties(System.out, properties);
            } else {
                int count = this.controller.fuseAllClosestStrands(this.root, this.name, this.resultRoot, this.cutoff);
                System.out.println("Performed " + count + " strand fusions!");
            }
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException("Error while performing automated strand fusing: " + e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter p = (StringParameter)this.getParameter("name");
        if (p != null) {
            this.name = p.getValue();
        }
        if ((p = (StringParameter)this.getParameter("root")) != null) {
            this.resultRoot = this.root = p.getValue();
        }
        if ((p = (StringParameter)this.getParameter("name")) != null) {
            this.name = p.getValue();
        }
        try {
            p = (StringParameter)this.getParameter("rms");
            if (p != null) {
                this.bridgeRms = Double.parseDouble(p.getValue());
            }
            if ((p = (StringParameter)this.getParameter("cutoff")) != null) {
                this.cutoff = Double.parseDouble(p.getValue());
            }
            if ((p = (StringParameter)this.getParameter("min")) != null) {
                this.lengthMin = Integer.parseInt(p.getValue());
            }
            if ((p = (StringParameter)this.getParameter("max")) != null) {
                this.lengthMax = Integer.parseInt(p.getValue());
            }
            if ((p = (StringParameter)this.getParameter("step")) != null) {
                this.stepMode = StringParameter.parseBoolean(p.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Could not interpret number: " + nfe.getMessage());
        }
        catch (ParsingException pe) {
            throw new CommandExecutionException("Could parse parameter: " + pe.getMessage());
        }
        if (!this.validate()) {
            throw new CommandExecutionException("Invalid parameters for fuseallstrands command!");
        }
    }

    public boolean validate() {
        return this.cutoff > 0.0 && this.lengthMin >= 0 && this.lengthMax >= this.lengthMin && this.name != null && this.name.length() > 0 && this.root != null && this.root.length() > 0 && this.resultRoot != null && this.resultRoot.length() > 0;
    }
}

