/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import rnadesign.rnacontrol.Object3DGraphController;
import viewer.display.DisplayFactory;
import viewer.display.DisplayGridLayout;
import viewer.display.MultiDisplay;
import viewer.view.ViewOrientation;

public class GLGraphicsCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "glgraphics";
    private Object3DGraphController controller;

    public GLGraphicsCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        return new GLGraphicsCommand(this.controller);
    }

    @Override
    public Command execute() throws CommandExecutionException {
        return null;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        int[][] grid = new int[][]{{1, 2}, {3, 4}};
        ViewOrientation[] orientations = new ViewOrientation[]{ViewOrientation.Top, ViewOrientation.Left, ViewOrientation.Back, ViewOrientation.PerspectiveTop};
        Dimension size = new Dimension(800, 600);
        DisplayGridLayout request = new DisplayGridLayout(grid, orientations, size);
        final MultiDisplay display = DisplayFactory.createDisplay(request);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame("Display Tester");
                frame.setDefaultCloseOperation(3);
                frame.add(display);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }
}

