/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import tools3d.objects3d.ConstraintLink;

public class GenerateDistanceConstraintCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "gendistconstraint";
    private Object3DGraphController controller;
    private String name1;
    private String name2;
    private double min = 0.0;
    private double max = 0.0;
    private int symId1 = 0;
    private int symId2 = 0;

    public GenerateDistanceConstraintCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        GenerateDistanceConstraintCommand command = new GenerateDistanceConstraintCommand(this.controller);
        command.name1 = this.name1;
        command.name2 = this.name2;
        command.min = this.min;
        command.max = this.max;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: gendistconstraint name1 name2 distmin distmax [sym1=ID][sym2=ID]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"gendistconstraint\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " objectname1 objectname2 distmin distmax [sym1=ID][sym2=ID]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Adds a distance constraint between two object descriptors." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            ConstraintLink newLink = this.controller.addDistanceConstraint(this.name1, this.name2, this.min, this.max, this.symId1, this.symId2);
            System.out.println("Added constraint for parameters:" + this.name1 + " " + this.name2 + " " + this.min + " " + this.max + " : " + newLink.toString());
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() < 4) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        this.name1 = p0.getValue();
        StringParameter p1 = (StringParameter)this.getParameter(1);
        this.name2 = p1.getValue();
        try {
            StringParameter sp2;
            StringParameter p2 = (StringParameter)this.getParameter(2);
            this.min = Double.parseDouble(p2.getValue());
            StringParameter p3 = (StringParameter)this.getParameter(3);
            this.max = Double.parseDouble(p3.getValue());
            StringParameter sp1 = (StringParameter)this.getParameter("sym1");
            if (sp1 != null) {
                this.symId1 = Integer.parseInt(sp1.getValue());
            }
            if ((sp2 = (StringParameter)this.getParameter("sym2")) != null) {
                this.symId2 = Integer.parseInt(sp2.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Error parsing number value: " + nfe.getMessage());
        }
    }
}

