/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class HelixConstraintCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "genhelixconstraint";
    private Object3DGraphController controller;
    private String name1;
    private String name2;
    private String name;
    private double rms = 3.0;
    private int symId1 = 0;
    private int symId2 = 0;
    private int basePairMin = 0;
    private int basePairMax = 0;

    public HelixConstraintCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        HelixConstraintCommand command = new HelixConstraintCommand(this.controller);
        command.name1 = this.name1;
        command.name2 = this.name2;
        command.name = this.name;
        command.rms = this.rms;
        command.basePairMin = this.basePairMin;
        command.basePairMax = this.basePairMax;
        command.symId1 = this.symId1;
        command.symId2 = this.symId2;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "Correct usage: genhelixconstraint name1 name2 [rms=<value>][bp=<value>][name=<name>]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"genhelixconstraint\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " helixdescriptor-1 helixdescriptor-2 [name=NAME][rms=value][bp=value][sym1=ID][sym2=ID]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Adds a helical constraint between two helix descriptors (BranchDescriptor3D)." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            this.controller.addHelixConstraint(this.name1, this.name2, this.basePairMin, this.basePairMax, this.rms, this.symId1, this.symId2, this.name);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() < 2) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        this.name1 = p0.getValue();
        StringParameter p1 = (StringParameter)this.getParameter(1);
        this.name2 = p1.getValue();
        try {
            StringParameter namePar;
            StringParameter sp2;
            StringParameter sp1;
            StringParameter bpMinParameter;
            StringParameter rmsParameter = (StringParameter)this.getParameter("rms");
            if (rmsParameter != null) {
                this.rms = Double.parseDouble(rmsParameter.getValue());
            }
            if ((bpMinParameter = (StringParameter)this.getParameter("bp")) != null) {
                this.basePairMax = this.basePairMin = Integer.parseInt(bpMinParameter.getValue());
            }
            if ((sp1 = (StringParameter)this.getParameter("sym1")) != null) {
                this.symId1 = Integer.parseInt(sp1.getValue());
            }
            if ((sp2 = (StringParameter)this.getParameter("sym2")) != null) {
                this.symId2 = Integer.parseInt(sp2.getValue());
            }
            if ((namePar = (StringParameter)this.getParameter("name")) != null) {
                this.name = namePar.getValue();
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Error parsing number value: " + nfe.getMessage());
        }
    }
}

