/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.BadSyntaxException;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import commandtools.UnknownCommandException;
import java.io.PrintStream;
import rnadesign.designapp.NanoTilerInterpreter;
import rnadesign.designapp.PackageConstants;

public class HelpCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "help";
    private NanoTilerInterpreter interpreter;
    private PrintStream ps;
    private String helpCommand;

    public HelpCommand(PrintStream ps, NanoTilerInterpreter interpreter) {
        super(COMMAND_NAME);
        assert (interpreter != null);
        assert (ps != null);
        this.ps = ps;
        this.interpreter = interpreter;
    }

    @Override
    public Object cloneDeep() {
        HelpCommand command = new HelpCommand(this.ps, this.interpreter);
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    @Override
    public String getName() {
        return COMMAND_NAME;
    }

    private String helpOutput() {
        return "User help for individual commands. Correct usage: help [COMMAND-NAME] . Try also commands \"man\" and \"demo\"";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"help\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " [COMMAND]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Help command gives list of known commands or short help for a specific command.";
        helpText = helpText + PackageConstants.NEWLINE + "     Currently known commands: " + this.interpreter.getKnownCommandNames() + PackageConstants.NEWLINE;
        helpText = helpText + "Consult the NanoTiler user manual located in $NANOTILER_HOME/doc for more information." + PackageConstants.NEWLINE;
        helpText = helpText + "Commands related to help: demo [all|NAME], help [COMMAND], man [COMMAND]";
        return helpText;
    }

    public String getMessage() {
        return "Known commands: " + this.interpreter.getKnownCommandNames() + PackageConstants.NEWLINE + "Consult the NanoTiler user manual located in $NANOTILER_HOME/doc for more information." + PackageConstants.NEWLINE + "Commands related to help: demo [all|NAME], help [COMMAND], man [COMMAND]";
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        if (this.helpCommand == null) {
            this.ps.println(this.getMessage());
        } else {
            this.ps.println(this.getOutput(this.helpCommand));
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private String getOutput(String helpCommand) {
        Command command = new HelpCommand(this.ps, this.interpreter);
        try {
            try {
                command = this.interpreter.interpretLine(helpCommand);
            }
            catch (UnknownCommandException ue) {
                log.severe("Unknown command!: " + ue.getMessage());
                return null;
            }
        }
        catch (BadSyntaxException e) {
            log.severe("Bad syntax!: " + e.getMessage());
            return null;
        }
        return command.getShortHelpText();
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() == 0) {
            return;
        }
        if (this.getParameterCount() != 1) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        this.helpCommand = p0.toString();
    }
}

