/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class SecondaryCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "secondary";
    private Object3DGraphController controller;
    private PrintStream ps;
    private String fileName;
    private int format = 13;

    public SecondaryCommand(PrintStream ps, Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        assert (ps != null);
        this.ps = ps;
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        SecondaryCommand command = new SecondaryCommand(this.ps, this.controller);
        command.fileName = this.fileName;
        command.format = this.format;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    private String helpOutput() {
        return "Correct usage: secondary[file=FILENAME][format=ct|fasta|sec|server]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"secondary\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " [file=FILENAME] [format=ct|fasta|sec|server]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Secondary command writes the secondary structure to a file." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        this.prepareReadout();
        try {
            if (this.fileName == null) {
                this.controller.writeSecondaryStructure(this.ps, this.format);
            } else {
                FileOutputStream fos = new FileOutputStream(this.fileName);
                PrintStream ps2 = new PrintStream(fos);
                this.controller.writeSecondaryStructure(ps2, this.format);
                fos.close();
            }
        }
        catch (IOException ioe) {
            throw new CommandExecutionException(ioe.getMessage());
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException(e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        StringParameter formatParameter;
        StringParameter fileParameter = (StringParameter)this.getParameter("file");
        if (fileParameter != null) {
            this.fileName = fileParameter.getValue();
        }
        if ((formatParameter = (StringParameter)this.getParameter("format")) != null) {
            String formatString = formatParameter.getValue();
            if (formatString.equals("ct")) {
                this.format = 14;
            } else if (formatString.equals("sec")) {
                this.format = 13;
            } else if (formatString.equals("fasta")) {
                this.format = 15;
            } else if (formatString.equals("server")) {
                this.format = 16;
            } else {
                throw new CommandExecutionException("Unknown format string: " + formatString);
            }
        }
    }
}

