/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.Vector3D;

public class ShiftCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "shift";
    private double a = 0.0;
    private double b = 0.0;
    private double c = 0.0;
    private double scalex = 1.0;
    private double scaley = 1.0;
    private double scalez = 1.0;
    private Object3DGraphController controller;

    public ShiftCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        ShiftCommand command = new ShiftCommand(this.controller);
        command.a = this.a;
        command.b = this.b;
        command.c = this.c;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    private String helpOutput() {
        return "Shift selected objects. Correct usage: shift x y z [scalex=value][scaley=value][scalez=value]";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"shift\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " x y z [options]" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Shift command moves an object x y z." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "OPTIONS" + PackageConstants.NEWLINE;
        helpText = helpText + "     scalex=NUM" + PackageConstants.NEWLINE + "          X scale value." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     scaley=NUM" + PackageConstants.NEWLINE + "          Y scale value." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "     scalez=NUM" + PackageConstants.NEWLINE + "          Z scale value." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        Object3DController gControl = this.controller.getGraph();
        Vector3D shift = new Vector3D(this.scalex * this.a, this.scaley * this.b, this.scalez * this.c);
        if (gControl.getSelectionRoot() == null) {
            gControl.translate(shift);
        } else {
            gControl.translateSelected(shift);
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() < 3) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        StringParameter p1 = (StringParameter)this.getParameter(1);
        StringParameter p2 = (StringParameter)this.getParameter(2);
        StringParameter scaleXPar = (StringParameter)this.getParameter("scalex");
        StringParameter scaleYPar = (StringParameter)this.getParameter("scaley");
        StringParameter scaleZPar = (StringParameter)this.getParameter("scalez");
        try {
            this.a = Double.parseDouble(p0.getValue());
            this.b = Double.parseDouble(p1.getValue());
            this.c = Double.parseDouble(p2.getValue());
            if (scaleXPar != null) {
                this.scalex = Double.parseDouble(scaleXPar.getValue());
            }
            if (scaleYPar != null) {
                this.scaley = Double.parseDouble(scaleYPar.getValue());
            }
            if (scaleZPar != null) {
                this.scalez = Double.parseDouble(scaleZPar.getValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new CommandExecutionException("Bad number syntax in command shift : " + nfe.getMessage());
        }
    }
}

