/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp;

import commandtools.AbstractCommand;
import commandtools.Command;
import commandtools.CommandExecutionException;
import commandtools.StringParameter;
import rnadesign.designapp.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;

public class SymmetryCommand
extends AbstractCommand {
    public static final String COMMAND_NAME = "symmetry";
    private int mode = 0;
    private Object3DGraphController controller;

    public SymmetryCommand(Object3DGraphController controller) {
        super(COMMAND_NAME);
        assert (controller != null);
        this.controller = controller;
    }

    @Override
    public Object cloneDeep() {
        SymmetryCommand command = new SymmetryCommand(this.controller);
        command.mode = this.mode;
        for (int i = 0; i < this.getParameterCount(); ++i) {
            command.addParameter((Command)this.getParameter(i).cloneDeep());
        }
        return command;
    }

    private String helpOutput() {
        return "Correct usage: symmetry none|cell|all";
    }

    @Override
    public String getShortHelpText() {
        return this.helpOutput();
    }

    @Override
    public String getLongHelpText() {
        String helpText = "\"symmetry\" Command Manual" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "NAME" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "SYNOPSIS" + PackageConstants.NEWLINE + "     " + COMMAND_NAME + " none|cell|all" + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        helpText = helpText + "DESCRIPTION" + PackageConstants.NEWLINE + "     Symmetry command TODO." + PackageConstants.NEWLINE + PackageConstants.NEWLINE;
        return helpText;
    }

    @Override
    public void executeWithoutUndo() throws CommandExecutionException {
        assert (this.controller != null);
        this.prepareReadout();
        try {
            this.controller.setSymmetryMode(this.mode);
        }
        catch (Object3DGraphControllerException e) {
            throw new CommandExecutionException("Error in symmetry command: " + e.getMessage());
        }
    }

    @Override
    public Command execute() throws CommandExecutionException {
        this.executeWithoutUndo();
        return null;
    }

    private void prepareReadout() throws CommandExecutionException {
        if (this.getParameterCount() != 1) {
            throw new CommandExecutionException(this.helpOutput());
        }
        StringParameter p0 = (StringParameter)this.getParameter(0);
        String s = p0.getValue();
        if ((s = s.toLowerCase()).equals("none")) {
            this.mode = 0;
        } else if (s.equals("cell")) {
            this.mode = 1;
        } else if (s.equals("all")) {
            this.mode = 2;
        } else {
            throw new CommandExecutionException("Command symmetry: unknown parameter " + s);
        }
    }
}

