/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.Object3DGraphControllerException;
import tools3d.Vector3D;
import tools3d.objects3d.Object3D;

public class GraphitGridWizard
implements GeneralWizard {
    private static final int COL_SIZE_DOUBLE = 8;
    private static final int COL_SIZE_INT = 5;
    private static final int COL_SIZE_NAME = 15;
    private boolean finished = false;
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private JFrame frame = null;
    private JTextField seqCharField;
    private JTextField axField;
    private JTextField ayField;
    private JTextField azField;
    private JTextField bxField;
    private JTextField byField;
    private JTextField bzField;
    private JTextField cxField;
    private JTextField cyField;
    private JTextField czField;
    private JTextField nameField;
    private JTextField nxField;
    private JTextField nyField;
    private JTextField nzField;
    private JTextField sxField;
    private JTextField syField;
    private JTextField szField;
    private JCheckBox addStemsBox;
    private JCheckBox onlyFirstPathBox;
    private JComboBox tilerChoice;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private Object3DGraphController graphController;
    private boolean addStemsFlag = false;
    private boolean onlyFirstPathMode = false;
    private double ax = 100.0;
    private double ay = 0.0;
    private double az = 0.0;
    private double bx = 0.0;
    private double by = 100.0;
    private double bz = 0.0;
    private double cx = 0.0;
    private double cy = 0.0;
    private double cz = 100.0;
    private double sx = 0.0;
    private double sy = 0.0;
    private double sz = 0.0;
    private int nx = 3;
    private int ny = 3;
    private int nz = 3;
    private int tilerAlgorithm = 3;
    private String name = "grid";
    private String charString = "N";
    public static final String FRAME_TITLE = "Insert Cubic Grid Wizard";
    private static String[] tilerNames = new String[]{"random", "complete", "simple", "fragment"};

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        if (graphController == null) {
            log.info("GraphController received by launchWizard is null!");
        }
        this.graphController = graphController;
        this.frame = new JFrame(FRAME_TITLE);
        this.addComponents(this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void addComponents(JFrame _frame) {
        Container f = _frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel center = new JPanel();
        center.setLayout(new BoxLayout(center, 1));
        JPanel topPanel = new JPanel();
        JPanel xPanel = new JPanel();
        JPanel yPanel = new JPanel();
        JPanel zPanel = new JPanel();
        JPanel sPanel = new JPanel();
        JPanel nPanel = new JPanel();
        JPanel checkPanel = new JPanel();
        this.addStemsBox = new JCheckBox("Add stems:", this.addStemsFlag);
        this.onlyFirstPathBox = new JCheckBox("Use first path:", this.onlyFirstPathMode);
        this.tilerChoice = new JComboBox<String>(tilerNames);
        this.seqCharField = new JTextField(this.charString, 1);
        this.axField = new JTextField("" + this.ax, 8);
        this.ayField = new JTextField("" + this.ay, 8);
        this.azField = new JTextField("" + this.az, 8);
        this.bxField = new JTextField("" + this.bx, 8);
        this.byField = new JTextField("" + this.by, 8);
        this.bzField = new JTextField("" + this.bz, 8);
        this.cxField = new JTextField("" + this.cx, 8);
        this.cyField = new JTextField("" + this.cy, 8);
        this.czField = new JTextField("" + this.cz, 8);
        this.sxField = new JTextField("" + this.sx, 8);
        this.syField = new JTextField("" + this.sy, 8);
        this.szField = new JTextField("" + this.sz, 8);
        this.nxField = new JTextField("" + this.nx, 5);
        this.nyField = new JTextField("" + this.ny, 5);
        this.nzField = new JTextField("" + this.nz, 5);
        this.nameField = new JTextField(this.name, 15);
        topPanel.add(new JLabel("Name:"));
        topPanel.add(this.nameField);
        topPanel.add(new JLabel("Sequence character:"));
        topPanel.add(this.seqCharField);
        xPanel.add(new JLabel("i: x:"));
        xPanel.add(this.axField);
        xPanel.add(new JLabel("y:"));
        xPanel.add(this.ayField);
        xPanel.add(new JLabel("z:"));
        xPanel.add(this.azField);
        yPanel.add(new JLabel("j: x:"));
        yPanel.add(this.bxField);
        yPanel.add(new JLabel("y:"));
        yPanel.add(this.byField);
        yPanel.add(new JLabel("z:"));
        yPanel.add(this.bzField);
        zPanel.add(new JLabel("k: x:"));
        zPanel.add(this.cxField);
        zPanel.add(new JLabel("y:"));
        zPanel.add(this.cyField);
        zPanel.add(new JLabel("z:"));
        zPanel.add(this.czField);
        sPanel.add(new JLabel("s: x:"));
        sPanel.add(this.sxField);
        sPanel.add(new JLabel("y:"));
        sPanel.add(this.syField);
        sPanel.add(new JLabel("z:"));
        sPanel.add(this.szField);
        nPanel.add(new JLabel("n: x:"));
        nPanel.add(this.nxField);
        nPanel.add(new JLabel("y:"));
        nPanel.add(this.nyField);
        nPanel.add(new JLabel("z:"));
        nPanel.add(this.nzField);
        checkPanel.add(this.addStemsBox);
        checkPanel.add(this.tilerChoice);
        checkPanel.add(this.onlyFirstPathBox);
        center.add(xPanel);
        center.add(yPanel);
        center.add(zPanel);
        center.add(sPanel);
        center.add(nPanel);
        center.add(checkPanel);
        JPanel bottomPanel = new JPanel();
        JButton button = new JButton("Cancel");
        button.addActionListener(new CancelListener());
        bottomPanel.add(button);
        button = new JButton("Done");
        button.addActionListener(new DoneListener());
        bottomPanel.add(button);
        f.add((Component)topPanel, "North");
        f.add((Component)bottomPanel, "South");
        f.add((Component)center, "Center");
    }

    private void readOutValues() {
        this.addStemsFlag = this.addStemsBox.isSelected();
        this.onlyFirstPathMode = this.onlyFirstPathBox.isSelected();
        this.charString = this.seqCharField.getText().trim();
        this.ax = Double.parseDouble(this.axField.getText().trim());
        this.ay = Double.parseDouble(this.ayField.getText().trim());
        this.az = Double.parseDouble(this.azField.getText().trim());
        this.bx = Double.parseDouble(this.bxField.getText().trim());
        this.by = Double.parseDouble(this.byField.getText().trim());
        this.bz = Double.parseDouble(this.bzField.getText().trim());
        this.cx = Double.parseDouble(this.cxField.getText().trim());
        this.cy = Double.parseDouble(this.cyField.getText().trim());
        this.cz = Double.parseDouble(this.czField.getText().trim());
        this.sx = Double.parseDouble(this.sxField.getText().trim());
        this.sy = Double.parseDouble(this.syField.getText().trim());
        this.sz = Double.parseDouble(this.szField.getText().trim());
        this.nx = Integer.parseInt(this.nxField.getText().trim());
        this.ny = Integer.parseInt(this.nyField.getText().trim());
        this.nz = Integer.parseInt(this.nzField.getText().trim());
        this.name = this.nameField.getText().trim();
        this.tilerAlgorithm = this.translateTilerId(this.tilerChoice.getSelectedIndex());
    }

    private int translateTilerId(int id) {
        switch (id) {
            case 0: {
                return 3;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 4;
            }
        }
        log.severe("internal error in PlatonicSolidWizard!");
        return 3;
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphitGridWizard.this.frame.setVisible(false);
            GraphitGridWizard.this.frame = null;
            GraphitGridWizard.this.finished = true;
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GraphitGridWizard.this.readOutValues();
            char sequenceChar = 'N';
            if (GraphitGridWizard.this.charString.length() > 0) {
                sequenceChar = GraphitGridWizard.this.charString.charAt(0);
            }
            boolean addGridFlag = true;
            Object3D toBeClonedObject = null;
            try {
                GraphitGridWizard.this.graphController.addGraphitGrid(new Vector3D(GraphitGridWizard.this.sx, GraphitGridWizard.this.sy, GraphitGridWizard.this.sz), GraphitGridWizard.this.ax, GraphitGridWizard.this.cz, GraphitGridWizard.this.nx, GraphitGridWizard.this.ny, GraphitGridWizard.this.name, toBeClonedObject, addGridFlag, GraphitGridWizard.this.addStemsFlag, sequenceChar, GraphitGridWizard.this.onlyFirstPathMode, GraphitGridWizard.this.tilerAlgorithm);
            }
            catch (Object3DGraphControllerException exc) {
                JOptionPane.showMessageDialog(GraphitGridWizard.this.frame, "An error occured during the tiling algorithm: " + exc.getMessage());
            }
            GraphitGridWizard.this.frame.setVisible(false);
            GraphitGridWizard.this.frame = null;
            GraphitGridWizard.this.finished = true;
        }
    }
}

