/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParseException;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunctionDB;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DTools;

public class GrowWizard
implements GeneralWizard {
    public static final String FRAME_TITLE = "Grow";
    private CommandApplication application;
    private static int version = 1;
    private static final Dimension PANEL_DIM = new Dimension(225, 225);
    private static final Dimension TABLE_DIM = new Dimension(200, 200);
    private JTable junctionTable;
    private JTable addedJunctionTable;
    private JTable constraintTable;
    private AbstractTableModel junctionTableModel;
    private AbstractTableModel addedJunctionTableModel;
    private BranchSelector branchSelector1;
    private BranchSelector branchSelector2;
    private JButton generate;
    private JButton close;
    private JButton addConstraint;
    private JButton removeConstraint;
    private JFormattedTextField basePairs;
    private boolean steric = true;
    private boolean helices = true;
    private int generations = 1;
    private double x = 0.0;
    private double y = 0.0;
    private double z = 0.0;
    private boolean useAdvanced = false;
    private ArrayList<Object3D> objects;
    private ArrayList<JunctionInfo> junctions;
    private ArrayList<JunctionInfo> addedJunctions;
    private ArrayList<JunctionInfo> availableJunctions;
    private ArrayList<ConstraintInfo> constraints;
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private boolean finished = false;
    private Object3DGraphController graphController;
    private JDialog frame;

    public GrowWizard(CommandApplication application) {
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        this.graphController = graphController;
        this.frame = new JDialog(parentFrame instanceof Frame ? (Frame)parentFrame : null, FRAME_TITLE, true);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                GrowWizard.this.finished = true;
            }
        });
        this.getJunctionInfo();
        this.constraints = new ArrayList();
        this.availableJunctions = new ArrayList();
        this.availableJunctions.addAll(this.junctions);
        this.frame.add(new BlockAdder());
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void getJunctionInfo() {
        JunctionInfo info;
        int i;
        StrandJunction3D[] j;
        this.junctions = new ArrayList();
        StrandJunctionDB db = this.graphController.getJunctionController().getKissingLoopDB();
        int numberJunctions = db.getJunctionCount();
        int junctionCount = 0;
        int order = 1;
        while (junctionCount != numberJunctions) {
            j = db.getJunctions(order);
            junctionCount += j.length;
            for (i = 0; i < j.length; ++i) {
                info = new JunctionInfo();
                info.junction = j[i];
                info.order = order;
                info.index = i + 1;
                info.type = "k";
                this.junctions.add(info);
            }
            ++order;
        }
        db = this.graphController.getJunctionController().getJunctionDB();
        numberJunctions = db.getJunctionCount();
        junctionCount = 0;
        order = 1;
        while (junctionCount != numberJunctions) {
            j = db.getJunctions(order);
            junctionCount += j.length;
            for (i = 0; i < j.length; ++i) {
                info = new JunctionInfo();
                info.junction = j[i];
                info.order = order;
                info.index = i + 1;
                info.type = "j";
                this.junctions.add(info);
            }
            ++order;
        }
    }

    private class BranchSelector
    extends JPanel {
        JTable junctionTable;
        JList branchTable;
        ListSelectionListener listener;

        BranchSelector(ListSelectionListener l) {
            this.listener = l;
            this.setLayout(new BoxLayout(this, 0));
            this.junctionTable = new JTable(GrowWizard.this.addedJunctionTableModel);
            this.junctionTable.getTableHeader().setReorderingAllowed(false);
            this.junctionTable.setColumnSelectionAllowed(false);
            ListSelectionModel lsm = this.junctionTable.getSelectionModel();
            lsm.setSelectionMode(0);
            lsm.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    GrowWizard.this.addConstraint.setEnabled(false);
                    if (BranchSelector.this.junctionTable.getSelectedRow() != -1) {
                        BranchSelector.this.junctionTable.setRowSelectionInterval(BranchSelector.this.junctionTable.getSelectedRow(), BranchSelector.this.junctionTable.getSelectedRow());
                        BranchSelector.this.branchTable.setEnabled(true);
                        GrowWizard.this.basePairs.setEnabled(true);
                    } else {
                        BranchSelector.this.branchTable.setEnabled(false);
                        GrowWizard.this.basePairs.setEnabled(false);
                    }
                    StrandJunction3D j = ((JunctionInfo)((GrowWizard)GrowWizard.this).addedJunctions.get((int)BranchSelector.this.junctionTable.getSelectedRow())).junction;
                    int size = j.getBranchCount();
                    Object[] branches = new Object[size];
                    for (int i = 0; i < size; ++i) {
                        branches[i] = new Integer(i + 1);
                    }
                    BranchSelector.this.branchTable.setModel(new DefaultComboBoxModel<Object>(branches));
                    BranchSelector.this.branchTable.revalidate();
                }
            });
            JScrollPane pane = new JScrollPane(this.junctionTable);
            pane.setPreferredSize(TABLE_DIM);
            this.add(pane);
            this.add(new JSeparator(1));
            this.branchTable = new JList();
            this.branchTable.setPreferredSize(TABLE_DIM);
            this.branchTable.setSelectionMode(0);
            this.branchTable.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    BranchSelector.this.listener.valueChanged(e);
                }
            });
            this.branchTable.setEnabled(false);
            pane = new JScrollPane(this.branchTable);
            pane.setPreferredSize(TABLE_DIM);
            this.add(pane);
        }

        @Override
        public void setEnabled(boolean b) {
            super.setEnabled(b);
            if (!b) {
                this.junctionTable.removeRowSelectionInterval(0, GrowWizard.this.addedJunctions.size());
            }
            this.branchTable.setEnabled(b);
            GrowWizard.this.basePairs.setEnabled(b);
        }

        public int getBasePairs() {
            return (Integer)GrowWizard.this.basePairs.getValue();
        }

        public int getJunction() {
            if (this.junctionTable.getSelectedRow() == -1) {
                return -1;
            }
            return this.junctionTable.getSelectedRow();
        }

        public int getBranch() {
            if (this.branchTable.getSelectedIndex() == -1) {
                return -1;
            }
            return this.branchTable.getSelectedIndex() + 1;
        }
    }

    private class JunctionTableModel
    extends AbstractTableModel {
        private String[] columns = new String[]{"Type", "Name", "Order", "ID"};
        private ArrayList<JunctionInfo> list;

        public JunctionTableModel(ArrayList<JunctionInfo> list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public int getRowCount() {
            return this.list.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.list.get((int)rowIndex).type;
                }
                case 1: {
                    return Object3DTools.getFullName(this.list.get((int)rowIndex).junction);
                }
                case 2: {
                    return this.list.get((int)rowIndex).order;
                }
                case 3: {
                    return this.list.get((int)rowIndex).index;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columns[columnIndex];
        }
    }

    private class ConstraintTableModel
    extends AbstractTableModel {
        private String[] columns = new String[]{"Junction 1", "Branch 1", "Junction 2", "Branch 2", "Base Pairs"};

        private ConstraintTableModel() {
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public int getRowCount() {
            return GrowWizard.this.constraints.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Object3DTools.getFullName(((JunctionInfo)((GrowWizard)GrowWizard.this).addedJunctions.get((int)((ConstraintInfo)((GrowWizard)GrowWizard.this).constraints.get((int)rowIndex)).j1)).junction);
                }
                case 1: {
                    return ((ConstraintInfo)((GrowWizard)GrowWizard.this).constraints.get((int)rowIndex)).b1;
                }
                case 2: {
                    return Object3DTools.getFullName(((JunctionInfo)((GrowWizard)GrowWizard.this).addedJunctions.get((int)((ConstraintInfo)((GrowWizard)GrowWizard.this).constraints.get((int)rowIndex)).j2)).junction);
                }
                case 3: {
                    return ((ConstraintInfo)((GrowWizard)GrowWizard.this).constraints.get((int)rowIndex)).b2;
                }
                case 4: {
                    return ((ConstraintInfo)((GrowWizard)GrowWizard.this).constraints.get((int)rowIndex)).bases;
                }
            }
            return null;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columns[columnIndex];
        }
    }

    private class AdvancedOptions
    extends JPanel {
        JRadioButton helicesTrue;
        JRadioButton helicesFalse;
        JRadioButton stericTrue;
        JRadioButton stericFalse;
        JTextField xLocation;
        JTextField yLocation;
        JTextField zLocation;
        JTextField generations;

        AdvancedOptions() {
            this.setLayout(new BoxLayout(this, 1));
            JPanel temp = new JPanel();
            this.generations = new JTextField(10);
            this.generations.setText("1");
            temp.add(new JLabel("Generations:"));
            temp.add(this.generations);
            this.add(temp);
            this.add(new JSeparator(0));
            temp = new JPanel();
            this.helicesTrue = new JRadioButton("True");
            this.helicesFalse = new JRadioButton("False");
            ButtonGroup group = new ButtonGroup();
            group.add(this.helicesTrue);
            group.add(this.helicesFalse);
            this.helicesTrue.setSelected(true);
            this.helicesFalse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrowWizard.this.helices = false;
                }
            });
            this.helicesTrue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrowWizard.this.helices = true;
                }
            });
            temp.add(new JLabel("Helices:"));
            temp.add(this.helicesTrue);
            temp.add(this.helicesFalse);
            this.add(temp);
            this.add(new JSeparator(0));
            temp = new JPanel();
            temp.add(new JLabel("X:"));
            this.xLocation = new JTextField(10);
            this.xLocation.setText("0.0");
            temp.add(this.xLocation);
            this.add(temp);
            temp = new JPanel();
            temp.add(new JLabel("Y:"));
            this.yLocation = new JTextField(10);
            this.yLocation.setText("0.0");
            temp.add(this.yLocation);
            this.add(temp);
            temp = new JPanel();
            temp.add(new JLabel("Z:"));
            this.zLocation = new JTextField(10);
            this.zLocation.setText("0.0");
            temp.add(this.zLocation);
            this.add(temp);
            this.add(new JSeparator(0));
            temp = new JPanel();
            this.stericTrue = new JRadioButton("True");
            this.stericFalse = new JRadioButton("False");
            group = new ButtonGroup();
            group.add(this.stericTrue);
            group.add(this.stericFalse);
            this.stericTrue.setSelected(true);
            this.stericFalse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrowWizard.this.steric = false;
                }
            });
            this.stericTrue.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrowWizard.this.steric = true;
                }
            });
            temp.add(new JLabel("Steric:"));
            temp.add(this.stericTrue);
            temp.add(this.stericFalse);
            this.add(temp);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
            bottomPanel.add(Box.createHorizontalGlue());
            JButton close = new JButton("Close");
            close.addActionListener(new CloseWindowListener());
            bottomPanel.add(close);
            bottomPanel.add(Box.createHorizontalStrut(10));
            JButton generate = new JButton("Generate");
            generate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrowWizard.this.useAdvanced = true;
                    try {
                        GrowWizard.this.generations = Integer.parseInt(AdvancedOptions.this.generations.getText());
                        if (GrowWizard.this.generations < 1) {
                            AdvancedOptions.this.generations.setText("1");
                            JOptionPane.showMessageDialog(GrowWizard.this.frame, "Generations must be greater than or equal to 1");
                            return;
                        }
                        GrowWizard.this.x = Double.parseDouble(AdvancedOptions.this.xLocation.getText());
                        GrowWizard.this.y = Double.parseDouble(AdvancedOptions.this.yLocation.getText());
                        GrowWizard.this.z = Double.parseDouble(AdvancedOptions.this.zLocation.getText());
                    }
                    catch (NumberFormatException ex) {
                        JOptionPane.showMessageDialog(GrowWizard.this.frame, "Must enter a number");
                        return;
                    }
                    GenerateListener listener = new GenerateListener();
                    listener.actionPerformed(e);
                }
            });
            bottomPanel.add(generate);
            this.add(bottomPanel);
        }
    }

    private class GenerateListener
    implements ActionListener {
        private GenerateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i;
            StringBuffer command = new StringBuffer();
            command.append("grow blocks=");
            for (i = 0; i < GrowWizard.this.addedJunctions.size(); ++i) {
                JunctionInfo j = (JunctionInfo)GrowWizard.this.addedJunctions.get(i);
                command.append(j.type + "," + j.order + "," + j.index);
                if (i >= GrowWizard.this.addedJunctions.size() - 1) continue;
                command.append(";");
            }
            command.append(" connect=");
            for (i = 0; i < GrowWizard.this.constraints.size(); ++i) {
                ConstraintInfo c = (ConstraintInfo)GrowWizard.this.constraints.get(i);
                command.append("" + (c.j1 + 1) + "," + (c.j2 + 1) + ",(hxend)" + c.b1 + ",(hxend)" + c.b2 + "," + c.bases);
                if (i >= GrowWizard.this.constraints.size() - 1) continue;
                command.append(";");
            }
            if (GrowWizard.this.useAdvanced) {
                command.append(" pos=" + GrowWizard.this.x + "," + GrowWizard.this.y + "," + GrowWizard.this.z + " ");
                command.append("gen=" + GrowWizard.this.generations + " ");
                command.append("steric=" + (GrowWizard.this.steric ? "true" : "false") + " ");
                command.append("helices=" + (GrowWizard.this.helices ? "true" : "false") + " ");
            }
            System.out.println(command);
            try {
                GrowWizard.this.application.runScriptLine(command.toString());
            }
            catch (CommandException ex) {
                JOptionPane.showMessageDialog(GrowWizard.this.frame, ex.getMessage());
                return;
            }
            GrowWizard.this.frame.setVisible(false);
            GrowWizard.this.frame.dispose();
        }
    }

    private class CloseWindowListener
    implements ActionListener {
        private CloseWindowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            GrowWizard.this.frame.setVisible(false);
            GrowWizard.this.frame.dispose();
        }
    }

    private class ConstraintAdder
    extends JPanel
    implements ListSelectionListener {
        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (GrowWizard.this.branchSelector1.getBranch() != -1 && GrowWizard.this.branchSelector2.getBranch() != -1) {
                GrowWizard.this.addConstraint.setEnabled(true);
            }
        }

        ConstraintAdder() {
            this.setLayout(new BoxLayout(this, 1));
            GrowWizard.this.branchSelector1 = new BranchSelector(this);
            GrowWizard.this.branchSelector2 = new BranchSelector(this);
            GrowWizard.this.constraintTable = new JTable(new ConstraintTableModel());
            GrowWizard.this.constraintTable.setColumnSelectionAllowed(false);
            GrowWizard.this.constraintTable.getTableHeader().setReorderingAllowed(false);
            ListSelectionModel lsm = GrowWizard.this.constraintTable.getSelectionModel();
            lsm.setSelectionMode(0);
            lsm.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    if (GrowWizard.this.constraintTable.getSelectedRow() != -1) {
                        GrowWizard.this.constraintTable.setRowSelectionInterval(GrowWizard.this.constraintTable.getSelectedRow(), GrowWizard.this.constraintTable.getSelectedRow());
                        GrowWizard.this.removeConstraint.setEnabled(true);
                    } else {
                        GrowWizard.this.removeConstraint.setEnabled(false);
                    }
                }
            });
            JScrollPane pane = new JScrollPane(GrowWizard.this.constraintTable);
            pane.setPreferredSize(new Dimension(600, 200));
            this.add(new JLabel("<html><h2 align=\"center\">Added Connections"));
            this.add(Box.createVerticalStrut(10));
            this.add(pane);
            JPanel selectorPanel = new JPanel();
            selectorPanel.setLayout(new BoxLayout(selectorPanel, 0));
            JPanel selectorPanelTemp = new JPanel();
            selectorPanelTemp.setLayout(new BoxLayout(selectorPanelTemp, 1));
            selectorPanelTemp.add(GrowWizard.this.branchSelector1);
            selectorPanelTemp.add(GrowWizard.this.branchSelector2);
            selectorPanel.add(selectorPanelTemp);
            GrowWizard.this.basePairs = new JFormattedTextField(new JFormattedTextField.AbstractFormatter(){

                @Override
                public Object stringToValue(String s) throws ParseException {
                    try {
                        return Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        throw new ParseException(e.getMessage(), 0);
                    }
                }

                @Override
                public String valueToString(Object o) throws ParseException {
                    if (o instanceof Number) {
                        Number n = (Number)o;
                        return "" + n.intValue();
                    }
                    throw new ParseException("Not a number", 0);
                }

                @Override
                public DocumentFilter getDocumentFilter() {
                    return new DocumentFilter(){

                        @Override
                        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                            try {
                                Integer.parseInt(string);
                                super.insertString(fb, offset, string, attr);
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                    };
                }
            });
            GrowWizard.this.basePairs.setValue(new Integer(0));
            GrowWizard.this.basePairs.setEnabled(false);
            GrowWizard.this.basePairs.setColumns(10);
            JPanel basePairsPanel = new JPanel();
            basePairsPanel.add(new JLabel("Base Pairs:"));
            basePairsPanel.add(GrowWizard.this.basePairs);
            selectorPanel.add(Box.createHorizontalStrut(15));
            selectorPanel.add(basePairsPanel);
            selectorPanel.add(new JSeparator(1));
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
            GrowWizard.this.addConstraint = new JButton("Add");
            GrowWizard.this.addConstraint.setEnabled(false);
            GrowWizard.this.addConstraint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConstraintInfo info = new ConstraintInfo();
                    int j1 = GrowWizard.this.branchSelector1.getJunction();
                    int j2 = GrowWizard.this.branchSelector2.getJunction();
                    int b1 = GrowWizard.this.branchSelector1.getBranch();
                    int b2 = GrowWizard.this.branchSelector2.getBranch();
                    int bases = (Integer)GrowWizard.this.basePairs.getValue();
                    if (j1 == -1 || j2 == -1 || b1 == -1 || b2 == -1) {
                        JOptionPane.showMessageDialog(GrowWizard.this.frame, "Cannot add constraint");
                        return;
                    }
                    info.j1 = j1;
                    info.j2 = j2;
                    info.b1 = b1;
                    info.b2 = b2;
                    info.bases = bases;
                    GrowWizard.this.constraints.add(info);
                    AbstractTableModel model = (AbstractTableModel)GrowWizard.this.constraintTable.getModel();
                    model.fireTableRowsInserted(GrowWizard.this.constraints.size() - 1, GrowWizard.this.constraints.size() - 1);
                    GrowWizard.this.generate.setEnabled(true);
                }
            });
            GrowWizard.this.removeConstraint = new JButton("Remove");
            GrowWizard.this.removeConstraint.setEnabled(false);
            GrowWizard.this.removeConstraint.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = GrowWizard.this.constraintTable.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    GrowWizard.this.constraints.remove(row);
                    if (GrowWizard.this.constraints.size() == 0) {
                        GrowWizard.this.removeConstraint.setEnabled(false);
                        GrowWizard.this.generate.setEnabled(false);
                    }
                    AbstractTableModel model = (AbstractTableModel)GrowWizard.this.constraintTable.getModel();
                    model.fireTableRowsDeleted(row, row);
                }
            });
            buttonPanel.add(GrowWizard.this.addConstraint);
            buttonPanel.add(Box.createVerticalStrut(10));
            buttonPanel.add(GrowWizard.this.removeConstraint);
            selectorPanel.add(buttonPanel);
            this.add(Box.createVerticalStrut(10));
            this.add(new JLabel("<html><h2 align=\"center\">Create / Add / Remove Connections"));
            this.add(Box.createVerticalStrut(10));
            this.add(selectorPanel);
            JPanel bottomPanel = new JPanel();
            bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
            bottomPanel.add(Box.createHorizontalGlue());
            GrowWizard.this.generate = new JButton("Generate");
            GrowWizard.this.generate.addActionListener(new GenerateListener());
            JButton close = new JButton("Close");
            close.addActionListener(new CloseWindowListener());
            bottomPanel.add(close);
            bottomPanel.add(Box.createHorizontalStrut(10));
            bottomPanel.add(GrowWizard.this.generate);
            GrowWizard.this.generate.setEnabled(false);
            JButton next = new JButton("Next");
            next.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrowWizard.this.frame.getContentPane().removeAll();
                    GrowWizard.this.frame.add(new AdvancedOptions());
                    GrowWizard.this.frame.pack();
                    GrowWizard.this.frame.repaint();
                }
            });
            bottomPanel.add(Box.createHorizontalStrut(10));
            bottomPanel.add(next);
            this.add(bottomPanel);
        }
    }

    private class BlockAdder
    extends JPanel {
        BlockAdder() {
            final JButton add = new JButton("Add");
            final JButton remove = new JButton("Remove");
            final JButton next = new JButton("Next");
            JPanel leftRight = new JPanel();
            leftRight.setLayout(new BoxLayout(leftRight, 0));
            GrowWizard.this.junctionTableModel = new JunctionTableModel(GrowWizard.this.availableJunctions);
            GrowWizard.this.junctionTable = new JTable(GrowWizard.this.junctionTableModel);
            GrowWizard.this.junctionTable.setColumnSelectionAllowed(false);
            GrowWizard.this.junctionTable.getTableHeader().setReorderingAllowed(false);
            ListSelectionModel lsm = GrowWizard.this.junctionTable.getSelectionModel();
            lsm.setSelectionMode(0);
            lsm.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    if (GrowWizard.this.junctionTable.getSelectedRow() != -1) {
                        GrowWizard.this.junctionTable.setRowSelectionInterval(GrowWizard.this.junctionTable.getSelectedRow(), GrowWizard.this.junctionTable.getSelectedRow());
                        add.setEnabled(true);
                    } else {
                        add.setEnabled(false);
                    }
                }
            });
            GrowWizard.this.addedJunctions = new ArrayList();
            GrowWizard.this.addedJunctionTableModel = new JunctionTableModel(GrowWizard.this.addedJunctions);
            GrowWizard.this.addedJunctionTable = new JTable(GrowWizard.this.addedJunctionTableModel);
            GrowWizard.this.addedJunctionTable.setColumnSelectionAllowed(false);
            GrowWizard.this.addedJunctionTable.getTableHeader().setReorderingAllowed(false);
            lsm = GrowWizard.this.addedJunctionTable.getSelectionModel();
            lsm.setSelectionMode(0);
            lsm.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        return;
                    }
                    if (GrowWizard.this.addedJunctionTable.getSelectedRow() != -1) {
                        GrowWizard.this.addedJunctionTable.setRowSelectionInterval(GrowWizard.this.addedJunctionTable.getSelectedRow(), GrowWizard.this.addedJunctionTable.getSelectedRow());
                        remove.setEnabled(true);
                    } else {
                        remove.setEnabled(false);
                    }
                }
            });
            add.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = GrowWizard.this.junctionTable.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    JunctionInfo info = (JunctionInfo)GrowWizard.this.availableJunctions.remove(row);
                    GrowWizard.this.addedJunctions.add(info);
                    if (GrowWizard.this.availableJunctions.size() == 0) {
                        add.setEnabled(false);
                    }
                    GrowWizard.this.junctionTableModel.fireTableRowsDeleted(row, row);
                    GrowWizard.this.addedJunctionTableModel.fireTableRowsInserted(GrowWizard.this.addedJunctions.size() - 1, GrowWizard.this.addedJunctions.size() - 1);
                    next.setEnabled(true);
                }
            });
            remove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = GrowWizard.this.addedJunctionTable.getSelectedRow();
                    if (row == -1) {
                        return;
                    }
                    JunctionInfo info = (JunctionInfo)GrowWizard.this.addedJunctions.remove(row);
                    GrowWizard.this.availableJunctions.add(info);
                    if (GrowWizard.this.addedJunctions.size() == 0) {
                        remove.setEnabled(false);
                        next.setEnabled(false);
                    }
                    GrowWizard.this.addedJunctionTableModel.fireTableRowsDeleted(row, row);
                    GrowWizard.this.junctionTableModel.fireTableRowsInserted(GrowWizard.this.addedJunctions.size() - 1, GrowWizard.this.addedJunctions.size() - 1);
                }
            });
            remove.setEnabled(false);
            add.setEnabled(false);
            JPanel tempPanel = new JPanel(new BorderLayout());
            tempPanel.add((Component)new JLabel("Available"), "North");
            tempPanel.add((Component)new JScrollPane(GrowWizard.this.junctionTable), "Center");
            tempPanel.add((Component)add, "South");
            tempPanel.setPreferredSize(PANEL_DIM);
            leftRight.add(tempPanel);
            leftRight.add(new JSeparator(1));
            tempPanel = new JPanel(new BorderLayout());
            tempPanel.add((Component)new JLabel("Added"), "North");
            tempPanel.add((Component)new JScrollPane(GrowWizard.this.addedJunctionTable), "Center");
            tempPanel.add((Component)remove, "South");
            tempPanel.setPreferredSize(PANEL_DIM);
            leftRight.add(tempPanel);
            this.setLayout(new BorderLayout());
            this.add((Component)leftRight, "Center");
            JPanel temp = new JPanel();
            temp.setLayout(new BoxLayout(temp, 0));
            temp.add(Box.createHorizontalGlue());
            JButton close = new JButton("Close");
            close.addActionListener(new CloseWindowListener());
            temp.add(close);
            temp.add(Box.createHorizontalStrut(10));
            next.setEnabled(false);
            next.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GrowWizard.this.frame.getContentPane().removeAll();
                    GrowWizard.this.frame.add(new ConstraintAdder());
                    GrowWizard.this.frame.pack();
                    GrowWizard.this.frame.repaint();
                }
            });
            temp.add(next);
            this.add((Component)temp, "South");
            this.add((Component)new JLabel("<html><h2>Add Junctions / Kissing Loops"), "North");
        }
    }

    private class ConstraintInfo {
        int j1;
        int j2;
        int b1;
        int b2;
        int bases;

        private ConstraintInfo() {
        }
    }

    private class JunctionInfo {
        StrandJunction3D junction;
        int order;
        int index;
        String type;

        private JunctionInfo() {
        }
    }
}

