/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandException;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import rnadesign.designapp.NanoTilerScripter;
import rnadesign.designapp.rnagui.FileExtensionException;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.designapp.rnagui.PackageConstants;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnamodel.FitParameters;
import rnadesign.rnamodel.FragmentGridTiler;
import tools3d.Vector3D;

public class ImportWizard
implements GeneralWizard {
    public static final int PDB_FORMAT = 5;
    public static final int POINTSET_FORMAT = 6;
    public static final int POINTSET2_FORMAT = 7;
    public static final int NTL_FORMAT = 8;
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final double RAD2DEG = 57.29577951308232;
    public static final double DEG2RAD = Math.PI / 180;
    private static final int COL_SIZE_DOUBLE = 8;
    private static final int COL_SIZE_INT = 5;
    private static final int COL_SIZE_NAME = 20;
    private static final int COL_SIZE_FILENAME = 50;
    private boolean finished = false;
    private JFrame frame = null;
    private JTextField nameField;
    private JTextField fileNameField;
    private JTextField seqCharField;
    private JTextField scaleField;
    private JTextField xStartField;
    private JTextField yStartField;
    private JTextField zStartField;
    private JTextField junctionMinOrderField;
    private JTextField junctionAngleLimitField;
    private JTextField junctionRmsLimitField;
    private JTextField stemAngleLimitField;
    private JTextField stemRmsLimitField;
    private JTextField rerunField;
    private JCheckBox addJunctionsBox;
    private JCheckBox addStemsBox;
    private JCheckBox connectingStemsBox;
    private JCheckBox findStemsBox;
    private JCheckBox forbiddenBox;
    private JCheckBox fuseStrandsBox;
    private JCheckBox junctionPlaceBox;
    private JCheckBox kissingLoopBox;
    private JCheckBox kissingLoopVerticeBox;
    private JCheckBox symmetryBox;
    private boolean addJunctionsDefault = true;
    private boolean addJunctionsFlag;
    private boolean addStemsDefault = true;
    private boolean addStemsFlag;
    private boolean connectingStemsDefault;
    private boolean findStemsDefault = false;
    private boolean findStemsFlag;
    private boolean forbiddenDefault;
    private boolean fuseStrandsDefault;
    private boolean junctionPlaceDefault = true;
    private boolean junctionPlaceFlag;
    private boolean kissingLoopDefault;
    private boolean kissingLoopVerticeDefault = false;
    private boolean kissingLoopVerticeFlag;
    private boolean symmetryDefault;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private Object3DGraphController graphController;
    FragmentGridTiler fgTiler;
    private Vector3D scale = new Vector3D(1.0, 1.0, 1.0);
    private double xStart = 0.0;
    private double yStart = 0.0;
    private double zStart = 0.0;
    private String name = "";
    private String pointsName = "point";
    private String pdbName = "import";
    private String charString = "N";
    private String fileName;
    private String usedDirectory;
    private int junctionCount = 0;
    private int kissingLoopCount = 0;
    private int formatId;
    private NanoTilerScripter nanoScripter;
    public static final String FRAME_TITLE = "Import Wizard";
    public static final String NTL_EXTENSION = ".ntl";
    public static final String PDB_EXTENSION = ".pdb";
    public static final String POINTS_EXTENSION = ".points";
    public static final String POINTS2_EXTENSION = ".points2";

    public ImportWizard(NanoTilerScripter nanoScripter) {
        this.nanoScripter = nanoScripter;
    }

    private String bool2String(boolean b) {
        return b ? "true" : "false";
    }

    private String buildCommand(String fileName, String name, Vector3D scale, double xStart, double yStart, double zStart, int formatId, boolean addStemsFlag, char sequenceChar, boolean findStemsFlag, boolean addJunctionsFlag) {
        return "import " + fileName + " name=" + name + " format=" + formatId + " addstems=" + this.bool2String(addStemsFlag) + " findstems=" + this.bool2String(findStemsFlag) + " addjunctions=" + this.bool2String(addJunctionsFlag);
    }

    private int getFormat(String fileName) {
        if (fileName.endsWith(POINTS_EXTENSION)) {
            return 6;
        }
        if (fileName.endsWith(POINTS2_EXTENSION)) {
            return 7;
        }
        if (fileName.endsWith(PDB_EXTENSION)) {
            return 5;
        }
        if (fileName.endsWith(NTL_EXTENSION)) {
            return 8;
        }
        log.severe("File extension not found: " + fileName + " Assuming PDB file format.");
        return 5;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        if (graphController == null) {
            log.info("GraphController received by launchWizard is null!");
        }
        this.graphController = graphController;
        try {
            this.junctionCount = this.graphController.getJunctionController().getJunctionDB() != null ? this.graphController.getJunctionController().getJunctionDB().getJunctionCount() : 0;
        }
        catch (AssertionError e) {
            log.info("No junctions found in DB");
        }
        try {
            this.kissingLoopCount = this.graphController.getJunctionController().getKissingLoopDB() != null ? this.graphController.getJunctionController().getKissingLoopDB().getJunctionCount() : 0;
        }
        catch (AssertionError e) {
            log.info("No kissing loops found in DB");
        }
        this.fgTiler = graphController.getFragmentGridTiler();
        this.setDefaultValues();
        this.frame = new JFrame(FRAME_TITLE);
        this.addComponents1(this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void addComponents2(JFrame _frame) {
        Container container = _frame.getContentPane();
        try {
            container.remove(1);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        container.setLayout(new BoxLayout(container, 1));
        JPanel bigPanel = new JPanel();
        bigPanel.setLayout(new BoxLayout(bigPanel, 1));
        bigPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        JPanel namePanel = new JPanel();
        this.nameField = new JTextField(this.name, 20);
        namePanel.add(new JLabel("Name:"));
        namePanel.add(this.nameField);
        JPanel startPanel = new JPanel();
        this.xStartField = new JTextField("" + this.xStart, 8);
        this.yStartField = new JTextField("" + this.yStart, 8);
        this.zStartField = new JTextField("" + this.zStart, 8);
        startPanel.add(new JLabel("offset: x:"));
        startPanel.add(this.xStartField);
        startPanel.add(new JLabel("y:"));
        startPanel.add(this.yStartField);
        startPanel.add(new JLabel("z:"));
        startPanel.add(this.zStartField);
        JPanel scalePanel = new JPanel();
        this.scaleField = new JTextField("1.0", 8);
        scalePanel.add(new JLabel("Scale:"));
        scalePanel.add(this.scaleField);
        bigPanel.add(namePanel);
        bigPanel.add(startPanel);
        bigPanel.add(scalePanel);
        if (this.formatId == 5 || this.formatId == 8) {
            this.addComponentsPdb(bigPanel);
        } else if (this.formatId == 6 || this.formatId == 7) {
            this.addComponentsPoints(bigPanel);
        } else {
            log.severe("This format not recognized: " + this.formatId + " Assuming PDB file format.");
            this.addComponentsPdb(bigPanel);
        }
        JPanel bottomPanel = new JPanel();
        JButton button = new JButton("Cancel");
        button.addActionListener(new CancelListener());
        bottomPanel.add(button);
        button = new JButton("Done");
        button.addActionListener(new DoneListener());
        bottomPanel.add(button);
        bigPanel.add(bottomPanel);
        container.add(bigPanel);
    }

    public void addComponentsPdb(JPanel bigPanel) {
        this.findStemsBox = new JCheckBox("Find stems", this.findStemsFlag);
        this.addJunctionsBox = new JCheckBox("Find junctions", this.findStemsFlag);
        JPanel checkPanel = new JPanel();
        checkPanel.setLayout(new BoxLayout(checkPanel, 1));
        checkPanel.add(this.findStemsBox);
        checkPanel.add(this.addJunctionsBox);
        bigPanel.add(checkPanel);
    }

    public void addComponentsPoints(JPanel bigPanel) {
        this.seqCharField = new JTextField(this.charString, 1);
        this.junctionMinOrderField = new JTextField("" + this.fgTiler.getJunctionMinOrder(), 5);
        this.rerunField = new JTextField("" + this.fgTiler.getRerunMax(), 5);
        String junctionAngleLimitText = "" + this.fgTiler.getJunctionFitParameters().getAngleLimit() * 57.29577951308232;
        if (junctionAngleLimitText.length() > 8) {
            junctionAngleLimitText = junctionAngleLimitText.substring(0, 8);
        }
        this.junctionAngleLimitField = new JTextField(junctionAngleLimitText, 8);
        String junctionRmsLimitText = "" + this.fgTiler.getJunctionFitParameters().getRmsLimit();
        if (junctionRmsLimitText.length() > 8) {
            junctionRmsLimitText = junctionRmsLimitText.substring(0, 8);
        }
        this.junctionRmsLimitField = new JTextField(junctionRmsLimitText, 8);
        String stemAngleLimitText = "" + this.fgTiler.getStemFitParameters().getAngleLimit() * 57.29577951308232;
        if (stemAngleLimitText.length() > 8) {
            stemAngleLimitText = stemAngleLimitText.substring(0, 8);
        }
        this.stemAngleLimitField = new JTextField(stemAngleLimitText, 8);
        String stemRmsLimitText = "" + this.fgTiler.getStemFitParameters().getRmsLimit();
        if (stemRmsLimitText.length() > 8) {
            stemRmsLimitText = stemRmsLimitText.substring(0, 8);
        }
        this.stemRmsLimitField = new JTextField(stemRmsLimitText, 8);
        JPanel labelPanel = new JPanel();
        labelPanel.setLayout(new BoxLayout(labelPanel, 1));
        JPanel fieldPanel = new JPanel();
        fieldPanel.setLayout(new BoxLayout(fieldPanel, 1));
        labelPanel.add(new JLabel("Sequence character:"));
        labelPanel.add(new JLabel("Minimum order to place:"));
        labelPanel.add(new JLabel("Reruns:"));
        labelPanel.add(new JLabel("Junction Angle Limit:"));
        labelPanel.add(new JLabel("Junction RMS Limit:"));
        labelPanel.add(new JLabel("Stem Angle Limit:"));
        labelPanel.add(new JLabel("Stem RMS Limit:"));
        fieldPanel.add(this.seqCharField);
        fieldPanel.add(this.junctionMinOrderField);
        fieldPanel.add(this.rerunField);
        fieldPanel.add(this.junctionAngleLimitField);
        fieldPanel.add(this.junctionRmsLimitField);
        fieldPanel.add(this.stemAngleLimitField);
        fieldPanel.add(this.stemRmsLimitField);
        JPanel paramPanel = new JPanel();
        paramPanel.setLayout(new FlowLayout());
        paramPanel.add(labelPanel);
        paramPanel.add(fieldPanel);
        JPanel checkPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        int[] columnW = new int[]{25, 25, 50};
        gbl.columnWidths = columnW;
        int[] rowH = new int[8];
        for (int i = 0; i < rowH.length; ++i) {
            rowH[i] = 20;
        }
        gbl.rowHeights = rowH;
        checkPanel.setLayout(gbl);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 0;
        gbc.anchor = 17;
        this.addStemsBox = new JCheckBox("Structure generator", this.addStemsFlag);
        this.addStemsBox.addActionListener(new AddStemsBoxListener());
        gbl.setConstraints(this.addStemsBox, gbc);
        ++gbc.gridx;
        ++gbc.gridy;
        this.junctionPlaceBox = new JCheckBox("Place junctions at vertices", this.junctionPlaceFlag);
        if (this.junctionCount > 0) {
            this.junctionPlaceBox.setEnabled(true);
        } else {
            this.junctionPlaceBox.setEnabled(false);
            this.junctionPlaceBox.setSelected(false);
            this.kissingLoopVerticeFlag = true;
            this.junctionPlaceBox.setToolTipText("No junctions in database.");
        }
        gbl.setConstraints(this.junctionPlaceBox, gbc);
        ++gbc.gridy;
        this.kissingLoopVerticeBox = new JCheckBox("Place kissing loops at vertices", this.kissingLoopVerticeFlag);
        if (this.kissingLoopCount > 0) {
            this.kissingLoopVerticeBox.setEnabled(true);
        } else {
            this.kissingLoopVerticeBox.setEnabled(false);
            this.kissingLoopVerticeBox.setSelected(false);
            this.kissingLoopVerticeBox.setToolTipText("No kissing loops in database.");
        }
        gbl.setConstraints(this.kissingLoopVerticeBox, gbc);
        ++gbc.gridy;
        this.connectingStemsBox = new JCheckBox("Generate connecting stems", this.fgTiler.getConnectJunctionsMode());
        this.connectingStemsBox.addActionListener(new ConnectingStemsBoxListener());
        gbl.setConstraints(this.connectingStemsBox, gbc);
        ++gbc.gridy;
        ++gbc.gridx;
        this.kissingLoopBox = new JCheckBox("Connect with kissing loops", this.fgTiler.getKissingLoopMode());
        gbl.setConstraints(this.kissingLoopBox, gbc);
        ++gbc.gridy;
        --gbc.gridx;
        this.forbiddenBox = new JCheckBox("Place each junction only once", this.fgTiler.getForbiddenMode());
        gbl.setConstraints(this.forbiddenBox, gbc);
        ++gbc.gridy;
        this.symmetryBox = new JCheckBox("Always use the same junction", this.fgTiler.getSymmetryMode());
        gbl.setConstraints(this.symmetryBox, gbc);
        ++gbc.gridy;
        this.fuseStrandsBox = new JCheckBox("Fuse stem strands with junction strands", this.fgTiler.getFuseJunctionStrandsMode());
        gbl.setConstraints(this.fuseStrandsBox, gbc);
        if (this.junctionCount + this.kissingLoopCount > 0) {
            this.addStemsBox.setEnabled(true);
        } else {
            this.addStemsBox.setEnabled(false);
            this.addStemsBox.setSelected(false);
            this.addStemsBox.setToolTipText("No junctions or kissing loops in DB");
            this.connectingStemsBox.setEnabled(false);
            this.connectingStemsBox.setSelected(false);
            this.kissingLoopBox.setEnabled(false);
            this.forbiddenBox.setEnabled(false);
            this.symmetryBox.setEnabled(false);
            this.fuseStrandsBox.setEnabled(false);
            this.fuseStrandsBox.setSelected(false);
        }
        checkPanel.add(this.addStemsBox);
        checkPanel.add(this.junctionPlaceBox);
        checkPanel.add(this.kissingLoopVerticeBox);
        checkPanel.add(this.connectingStemsBox);
        checkPanel.add(this.kissingLoopBox);
        checkPanel.add(this.forbiddenBox);
        checkPanel.add(this.symmetryBox);
        checkPanel.add(this.fuseStrandsBox);
        bigPanel.add(paramPanel);
        bigPanel.add(checkPanel);
    }

    private void setDefaultValues() {
        this.findStemsDefault = false;
        this.addJunctionsDefault = false;
        if (this.junctionCount + this.kissingLoopCount > 0) {
            this.addStemsDefault = true;
            this.connectingStemsDefault = this.fgTiler.getConnectJunctionsMode();
            this.forbiddenDefault = this.fgTiler.getForbiddenMode();
            this.symmetryDefault = this.fgTiler.getSymmetryMode();
            this.fuseStrandsDefault = this.fgTiler.getFuseJunctionStrandsMode();
            if (this.junctionCount > 0) {
                this.junctionPlaceDefault = true;
                this.kissingLoopVerticeDefault = false;
                this.kissingLoopDefault = false;
            } else {
                this.junctionPlaceDefault = false;
                this.kissingLoopVerticeDefault = true;
                this.connectingStemsDefault = true;
                if (true) {
                    this.kissingLoopDefault = this.fgTiler.getKissingLoopMode();
                }
            }
        } else {
            this.addStemsDefault = false;
            this.connectingStemsDefault = false;
            this.junctionPlaceDefault = false;
            this.kissingLoopVerticeDefault = false;
            this.kissingLoopDefault = false;
            this.forbiddenDefault = false;
            this.symmetryDefault = false;
            this.fuseStrandsDefault = false;
        }
        this.addStemsFlag = this.addStemsDefault;
        this.findStemsFlag = this.findStemsDefault;
        this.addJunctionsFlag = this.addJunctionsDefault;
        this.junctionPlaceFlag = this.junctionPlaceDefault;
        this.kissingLoopVerticeFlag = this.kissingLoopVerticeDefault;
    }

    public void addComponents1(JFrame _frame) {
        Container container = _frame.getContentPane();
        JPanel bigPanel = new JPanel();
        bigPanel.setLayout(new BoxLayout(bigPanel, 1));
        bigPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        JPanel filePanel = new JPanel();
        filePanel.add(new JLabel("Filename:"));
        this.fileNameField = new JTextField(this.fileName, 50);
        filePanel.add(this.fileNameField);
        JButton button = new JButton("Browse");
        button.addActionListener(new BrowseActionListener());
        filePanel.add(button);
        bigPanel.add(filePanel);
        container.add(bigPanel);
    }

    private void readOutValues() throws FileExtensionException {
        try {
            this.junctionPlaceFlag = this.junctionPlaceBox.isSelected();
            this.kissingLoopVerticeFlag = this.kissingLoopVerticeBox.isSelected();
            this.addStemsFlag = this.addStemsBox.isSelected();
            FitParameters junctionFitParameters = this.fgTiler.getJunctionFitParameters();
            junctionFitParameters.setAngleLimit(Math.PI / 180 * Double.parseDouble(this.junctionAngleLimitField.getText().trim()));
            junctionFitParameters.setRmsLimit(Double.parseDouble(this.junctionRmsLimitField.getText().trim()));
            this.fgTiler.setJunctionFitParameters(junctionFitParameters);
            this.fgTiler.setForbiddenMode(this.forbiddenBox.isSelected());
            this.fgTiler.setConnectJunctionsMode(this.connectingStemsBox.isSelected());
            this.fgTiler.setKissingLoopMode(this.kissingLoopBox.isSelected());
            this.fgTiler.setKissingLoopJunctionMode(this.kissingLoopVerticeFlag);
            this.fgTiler.setRerunMax(Integer.parseInt(this.rerunField.getText().trim()));
            this.fgTiler.setSymmetryMode(this.symmetryBox.isSelected());
            if (this.fuseStrandsBox.isSelected()) {
                this.fgTiler.setAppendStrandsMode(2);
            } else {
                this.fgTiler.setAppendStrandsMode(0);
            }
            FitParameters stemFitParameters = this.fgTiler.getStemFitParameters();
            stemFitParameters.setAngleLimit(Math.PI / 180 * Double.parseDouble(this.stemAngleLimitField.getText().trim()));
            stemFitParameters.setRmsLimit(Double.parseDouble(this.stemRmsLimitField.getText().trim()));
            this.fgTiler.setStemFitParameters(stemFitParameters);
            this.fgTiler.setJunctionMinOrder(Integer.parseInt(this.junctionMinOrderField.getText().trim()));
            this.charString = this.seqCharField.getText().trim();
        }
        catch (NullPointerException npe) {
            this.findStemsFlag = this.findStemsBox.isSelected();
            this.addJunctionsFlag = this.addJunctionsBox.isSelected();
        }
        this.xStart = Double.parseDouble(this.xStartField.getText().trim());
        this.yStart = Double.parseDouble(this.yStartField.getText().trim());
        this.zStart = Double.parseDouble(this.zStartField.getText().trim());
        double scaleFactor = Double.parseDouble(this.scaleField.getText().trim());
        if (scaleFactor != 1.0) {
            this.scale = new Vector3D(scaleFactor, scaleFactor, scaleFactor);
        }
        this.fileName = this.fileNameField.getText().trim();
        if (!(this.fileName.endsWith(POINTS_EXTENSION) || this.fileName.endsWith(POINTS2_EXTENSION) || this.fileName.endsWith(PDB_EXTENSION) || this.fileName.endsWith(NTL_EXTENSION))) {
            throw new FileExtensionException(this.fileName);
        }
        this.name = this.nameField.getText().trim();
    }

    private class AddStemsBoxListener
    implements ActionListener {
        private AddStemsBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImportWizard.this.addStemsBox.isSelected()) {
                ImportWizard.this.junctionPlaceBox.setEnabled(true);
                ImportWizard.this.junctionPlaceBox.setSelected(ImportWizard.this.junctionPlaceDefault);
                ImportWizard.this.kissingLoopVerticeBox.setEnabled(true);
                ImportWizard.this.kissingLoopVerticeBox.setSelected(ImportWizard.this.kissingLoopVerticeDefault);
                ImportWizard.this.connectingStemsBox.setEnabled(true);
                ImportWizard.this.connectingStemsBox.setSelected(ImportWizard.this.connectingStemsDefault);
                ImportWizard.this.kissingLoopBox.setEnabled(true);
                ImportWizard.this.kissingLoopBox.setSelected(ImportWizard.this.kissingLoopDefault);
                ImportWizard.this.forbiddenBox.setEnabled(true);
                ImportWizard.this.forbiddenBox.setSelected(ImportWizard.this.forbiddenDefault);
                ImportWizard.this.symmetryBox.setEnabled(true);
                ImportWizard.this.symmetryBox.setSelected(ImportWizard.this.symmetryDefault);
                ImportWizard.this.fuseStrandsBox.setEnabled(true);
                ImportWizard.this.fuseStrandsBox.setSelected(ImportWizard.this.fuseStrandsDefault);
            } else {
                ImportWizard.this.junctionPlaceBox.setEnabled(false);
                ImportWizard.this.junctionPlaceBox.setSelected(false);
                ImportWizard.this.kissingLoopVerticeBox.setEnabled(false);
                ImportWizard.this.kissingLoopVerticeBox.setSelected(false);
                ImportWizard.this.connectingStemsBox.setEnabled(false);
                ImportWizard.this.connectingStemsBox.setSelected(false);
                ImportWizard.this.kissingLoopBox.setEnabled(false);
                ImportWizard.this.kissingLoopBox.setSelected(false);
                ImportWizard.this.forbiddenBox.setEnabled(false);
                ImportWizard.this.forbiddenBox.setSelected(false);
                ImportWizard.this.symmetryBox.setEnabled(false);
                ImportWizard.this.symmetryBox.setSelected(false);
                ImportWizard.this.fuseStrandsBox.setEnabled(false);
                ImportWizard.this.fuseStrandsBox.setSelected(false);
            }
        }
    }

    private class ConnectingStemsBoxListener
    implements ActionListener {
        private ConnectingStemsBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ImportWizard.this.connectingStemsBox.isSelected()) {
                ImportWizard.this.kissingLoopBox.setEnabled(true);
            } else {
                ImportWizard.this.kissingLoopBox.setEnabled(false);
                ImportWizard.this.kissingLoopBox.setSelected(false);
                ImportWizard.this.kissingLoopBox.setToolTipText("Generating stems mode not selected.");
            }
        }
    }

    private class BrowseActionListener
    implements ActionListener {
        private BrowseActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser chooser = new JFileChooser();
            ImportFileFilter filter = new ImportFileFilter();
            chooser.setFileSelectionMode(2);
            chooser.setFileFilter(filter);
            String cwdName = ImportWizard.this.graphController.getLastReadDirectory();
            File cwd = new File(cwdName);
            chooser.setCurrentDirectory(cwd);
            int returnVal = chooser.showOpenDialog(ImportWizard.this.frame);
            if (returnVal == 0) {
                ImportWizard.this.fileName = chooser.getCurrentDirectory() + PackageConstants.SLASH + chooser.getSelectedFile().getName();
                ImportWizard.this.fileNameField.setText(ImportWizard.this.fileName);
                ImportWizard.this.usedDirectory = chooser.getCurrentDirectory().getAbsolutePath();
                if (ImportWizard.this.fileName.endsWith(ImportWizard.PDB_EXTENSION) || ImportWizard.this.fileName.endsWith(ImportWizard.NTL_EXTENSION)) {
                    ImportWizard.this.name = ImportWizard.this.pdbName;
                } else if (ImportWizard.this.fileName.endsWith(ImportWizard.POINTS_EXTENSION) || ImportWizard.this.fileName.endsWith(ImportWizard.POINTS2_EXTENSION)) {
                    ImportWizard.this.name = ImportWizard.this.pointsName;
                } else {
                    log.warning("Not PDB, NTL, or points file!!: " + ImportWizard.this.fileName + " Assuming PDB format!");
                    ImportWizard.this.name = ImportWizard.this.pdbName;
                }
                log.info("You chose this file: " + ImportWizard.this.fileName);
                ImportWizard.this.formatId = ImportWizard.this.getFormat(ImportWizard.this.fileName);
                ImportWizard.this.addComponents2(ImportWizard.this.frame);
                ImportWizard.this.frame.pack();
                ImportWizard.this.frame.setVisible(true);
            }
        }
    }

    class ImportFileFilter
    extends FileFilter {
        ImportFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            boolean b = f.isDirectory() || f.getName().toLowerCase().endsWith(ImportWizard.POINTS_EXTENSION) || f.getName().toLowerCase().endsWith(ImportWizard.POINTS2_EXTENSION) || f.getName().toLowerCase().endsWith(ImportWizard.PDB_EXTENSION) || f.getName().toLowerCase().endsWith(ImportWizard.NTL_EXTENSION);
            return b;
        }

        @Override
        public String getDescription() {
            return "Importable files";
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ImportWizard.this.frame.setVisible(false);
            ImportWizard.this.frame = null;
            ImportWizard.this.finished = true;
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ImportWizard.this.readOutValues();
                char sequenceChar = 'N';
                if (ImportWizard.this.charString.length() > 0) {
                    sequenceChar = ImportWizard.this.charString.charAt(0);
                }
                try {
                    String command = ImportWizard.this.buildCommand(ImportWizard.this.fileName, ImportWizard.this.name, ImportWizard.this.scale, ImportWizard.this.xStart, ImportWizard.this.yStart, ImportWizard.this.zStart, ImportWizard.this.formatId, ImportWizard.this.addStemsFlag, sequenceChar, ImportWizard.this.findStemsFlag, ImportWizard.this.addJunctionsFlag);
                    System.out.println("Calling import command: " + command);
                    ImportWizard.this.nanoScripter.runScriptLine(command);
                }
                catch (CommandException exc) {
                    JOptionPane.showMessageDialog(ImportWizard.this.frame, "Error importing file: " + ImportWizard.this.fileName + " : " + exc.getMessage());
                    return;
                }
                ImportWizard.this.frame.setVisible(false);
                ImportWizard.this.frame = null;
                ImportWizard.this.finished = true;
                ImportWizard.this.graphController.setLastReadDirectory(ImportWizard.this.usedDirectory);
            }
            catch (FileExtensionException fee) {
                JOptionPane.showMessageDialog(ImportWizard.this.frame, "Error importing file due to bad file extension: " + ImportWizard.this.fileName + " : " + fee.getMessage());
                return;
            }
        }
    }
}

