/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.designapp.rnagui.Object3DTreePanel;
import rnadesign.rnacontrol.Object3DGraphController;
import tools3d.objects3d.Object3D;

public class InsertLinkWizard
implements GeneralWizard {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean finished = false;
    private JFrame frame = null;
    private Object3DTreePanel leftTreePanel;
    private Object3DTreePanel rightTreePanel;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private Object3DGraphController graphController;
    public static final String FRAME_TITLE = "Insert Link Wizard";

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        if (graphController == null) {
            log.info("GraphController received by launchWizard is null!");
        }
        this.graphController = graphController;
        this.frame = new JFrame(FRAME_TITLE);
        this.addComponents(this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void addComponents(JFrame _frame) {
        Container f = _frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel center = new JPanel();
        center.setLayout(new FlowLayout());
        if (this.graphController == null) {
            log.info("GraphController is null before generating left and right tree panels!");
        }
        this.leftTreePanel = new Object3DTreePanel(this.graphController.getGraph());
        this.rightTreePanel = new Object3DTreePanel(this.graphController.getGraph());
        center.add(this.leftTreePanel);
        center.add(this.rightTreePanel);
        f.add((Component)center, "Center");
        JPanel bottomPanel = new JPanel();
        JButton button = new JButton("Cancel");
        button.addActionListener(new CancelListener());
        bottomPanel.add(button);
        button = new JButton("Done");
        button.addActionListener(new DoneListener());
        bottomPanel.add(button);
        f.add((Component)bottomPanel, "South");
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            InsertLinkWizard.this.frame.setVisible(false);
            InsertLinkWizard.this.frame = null;
            InsertLinkWizard.this.finished = true;
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object3D o1 = InsertLinkWizard.this.leftTreePanel.getLastSelected();
            Object3D o2 = InsertLinkWizard.this.rightTreePanel.getLastSelected();
            if (o1 != null && o2 != null) {
                InsertLinkWizard.this.graphController.getLinks().addLink(o1, o2);
                InsertLinkWizard.this.frame.setVisible(false);
                InsertLinkWizard.this.frame = null;
                InsertLinkWizard.this.finished = true;
            }
        }
    }
}

