/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import rnadesign.designapp.rnagui.AbstractGeometryPainter;
import rnadesign.designapp.rnagui.AbstractPainter;
import rnadesign.designapp.rnagui.GeometryPainter;
import rnadesign.designapp.rnagui.GeometryPainterFactory;
import rnadesign.designapp.rnagui.NoLinkGeometryPainter;
import rnadesign.designapp.rnagui.RainbowColorModel;
import rnadesign.designapp.rnagui.RnaStrandColorModel;
import rnadesign.designapp.rnagui.SolidGeometryPainter;
import rnadesign.designapp.rnagui.WireFrameGeometryPainter;
import rnadesign.designapp.rnagui.WireGeometryCharactersPainter;
import rnadesign.designapp.rnagui.WireGeometryPainter;
import tools3d.GeometryColorModel;

public class NanoTilerGeometryPainterFactory
implements GeometryPainterFactory {
    public static final int STANDARD_PAINTER = 2;
    public static final int SOLID_PAINTER = 2;
    public static final int WIRE_PAINTER = 3;
    public static final int WIREFRAME_PAINTER = 4;
    public static final int WIRE_CHARACTER_PAINTER = 5;
    public static final int NO_LINK_PAINTER = 6;
    public static final int RAINBOW_PAINTER = 7;
    public static final int RNASTRAND_PAINTER = 8;

    public AbstractGeometryPainter createWirePainter() {
        return new WireGeometryPainter();
    }

    public AbstractGeometryPainter createSolidPainter() {
        return new SolidGeometryPainter();
    }

    public AbstractGeometryPainter createWireFramePainter() {
        return new WireFrameGeometryPainter();
    }

    public AbstractPainter createWireCharacterPainter() {
        return new WireGeometryCharactersPainter();
    }

    public AbstractGeometryPainter createNoLinkPainter() {
        return new NoLinkGeometryPainter();
    }

    public GeometryColorModel createRainbowPainter() {
        return new RainbowColorModel();
    }

    public GeometryColorModel createRnaStrandPainter() {
        return new RnaStrandColorModel();
    }

    public GeometryPainter createPainter() {
        return this.createPainter(2);
    }

    @Override
    public GeometryPainter createPainter(int styleId) {
        return this.createPainter(styleId, true);
    }

    @Override
    public GeometryPainter createPainter(int styleId, boolean paintLinks) {
        AbstractGeometryPainter shapePainter = null;
        Object colorModel = null;
        switch (styleId) {
            case 2: {
                shapePainter = this.createSolidPainter();
                break;
            }
            case 3: 
            case 5: {
                shapePainter = this.createWirePainter();
                break;
            }
            case 4: {
                shapePainter = this.createWireFramePainter();
                break;
            }
        }
        shapePainter.setPaintLinks(paintLinks);
        return shapePainter;
    }
}

