/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.designapp.rnagui.Object3DTreePanel;
import rnadesign.rnacontrol.Object3DController;
import rnadesign.rnacontrol.Object3DGraphController;

public class RotateWizard
implements GeneralWizard {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    private boolean finished = false;
    private JFrame frame = null;
    private JTextField axField;
    private JTextField ayField;
    private JTextField azField;
    private JTextField angleField;
    private Object3DTreePanel leftTreePanel;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private Object3DController graphController;
    private double ax = 1.0;
    private double ay = 0.0;
    private double az = 0.0;
    private double angle = 0.0;
    public static final String FRAME_TITLE = "Insert Link Wizard";

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        if (graphController == null) {
            log.info("GraphController received by launchWizard is null!");
        }
        this.graphController = graphController.getGraph();
        this.frame = new JFrame(FRAME_TITLE);
        this.addComponents(this.frame);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    public void addComponents(JFrame _frame) {
        Container f = _frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel center = new JPanel();
        center.setLayout(new FlowLayout());
        if (this.graphController == null) {
            log.info("GraphController is null before generating left and right tree panels!");
        }
        f.add((Component)center, "Center");
        JPanel topPanel = new JPanel();
        this.axField = new JTextField("0.0");
        this.ayField = new JTextField("0.0");
        this.azField = new JTextField("1.0");
        this.angleField = new JTextField("0.0");
        topPanel.add(new JLabel("Axis x:"));
        topPanel.add(this.axField);
        topPanel.add(new JLabel("y:"));
        topPanel.add(this.ayField);
        topPanel.add(new JLabel("z:"));
        topPanel.add(this.azField);
        topPanel.add(new JLabel("angle:"));
        topPanel.add(this.angleField);
        JPanel bottomPanel = new JPanel();
        JButton button = new JButton("Cancel");
        button.addActionListener(new CancelListener());
        bottomPanel.add(button);
        button = new JButton("Done");
        button.addActionListener(new DoneListener());
        bottomPanel.add(button);
        f.add((Component)topPanel, "North");
        f.add((Component)bottomPanel, "South");
    }

    private void readOutValues() {
        this.ax = Double.parseDouble(this.axField.getText().trim());
        this.ay = Double.parseDouble(this.ayField.getText().trim());
        this.az = Double.parseDouble(this.azField.getText().trim());
        this.angle = Double.parseDouble(this.angleField.getText().trim());
        this.angle *= Math.PI / 180;
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RotateWizard.this.frame.setVisible(false);
            RotateWizard.this.frame = null;
            RotateWizard.this.finished = true;
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RotateWizard.this.readOutValues();
            RotateWizard.this.graphController.rotateSelected(RotateWizard.this.ax, RotateWizard.this.ay, RotateWizard.this.az, RotateWizard.this.angle);
            RotateWizard.this.frame.setVisible(false);
            RotateWizard.this.frame = null;
            RotateWizard.this.finished = true;
        }
    }
}

