/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import commandtools.CommandApplication;
import commandtools.CommandException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;

public class RunScriptWizard
implements GeneralWizard {
    public static final String FRAME_TITLE = "Run Script";
    private CommandApplication application;
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    private boolean finished = false;
    private Object3DGraphController graphController;
    private JFrame frame;

    public RunScriptWizard(CommandApplication application) {
        this.application = application;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        this.graphController = graphController;
        this.frame = new JFrame(FRAME_TITLE);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                RunScriptWizard.this.finished = true;
            }
        });
        JPanel panel = new JPanel();
        final JTextField scriptLocation = new JTextField(40);
        panel.add(scriptLocation);
        JButton browse = new JButton("Browse");
        browse.setToolTipText("Browse to a script file");
        browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setFileSelectionMode(0);
                String cwdName = RunScriptWizard.this.graphController.getLastReadDirectory();
                File cwd = new File(cwdName);
                fileChooser.setCurrentDirectory(cwd);
                int result = fileChooser.showOpenDialog(RunScriptWizard.this.frame);
                if (result == 0) {
                    File file = fileChooser.getSelectedFile();
                    scriptLocation.setText(file.getAbsolutePath());
                }
            }
        });
        panel.add(browse);
        JButton run = new JButton("Run");
        run.setToolTipText("Run the script");
        run.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (scriptLocation.getText().equals("")) {
                    JOptionPane.showMessageDialog(RunScriptWizard.this.frame, "Must specify the path to a script file");
                }
                try {
                    RunScriptWizard.this.application.runScriptLine("source " + scriptLocation.getText());
                    scriptLocation.setText("");
                }
                catch (CommandException ex) {
                    JOptionPane.showMessageDialog(RunScriptWizard.this.frame, ex.getMessage());
                }
            }
        });
        panel.add(run);
        JButton close = new JButton("Close");
        close.setToolTipText("Close the wizard");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunScriptWizard.this.frame.setVisible(false);
                RunScriptWizard.this.frame.dispose();
            }
        });
        panel.add(close);
        this.frame.add(panel);
        this.frame.pack();
        this.frame.setVisible(true);
    }
}

