/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import SecondaryStructureDesign.SecondaryStructureEditorPanel;
import commandtools.CommandApplication;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JDialog;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;
import rnasecondary.MutableSecondaryStructure;
import rnasecondary.SimpleMutableSecondaryStructure;
import sequence.DuplicateNameException;

public class SecondaryStructureEditorWizardNoThread
implements GeneralWizard {
    private Object3DGraphController graphController;
    public static final String FRAME_TITLE = "Secondary Structure Editor";
    private MutableSecondaryStructure structure;
    private ArrayList<ActionListener> actionListeners = new ArrayList();
    boolean finished = false;
    private CommandApplication app;

    public SecondaryStructureEditorWizardNoThread(CommandApplication app) {
        this.app = app;
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void cleanUp() {
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    public void fireActionPerformed(ActionEvent e) {
        for (ActionListener l : this.actionListeners) {
            l.actionPerformed(e);
        }
    }

    public MutableSecondaryStructure getSecondaryStructure() {
        return this.structure;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        this.graphController = graphController;
        MutableSecondaryStructure structure = null;
        try {
            structure = graphController.generateSecondaryStructure();
            System.out.println("Generating secondary structure");
        }
        catch (DuplicateNameException dne) {
            structure = new SimpleMutableSecondaryStructure();
        }
        MutableSecondaryStructure ss = structure;
        Component c = parentFrame;
        Frame frame = null;
        JDialog dialog = new JDialog(frame, FRAME_TITLE, true);
        dialog.setLayout(new BorderLayout());
        final SecondaryStructureEditorPanel ssep = new SecondaryStructureEditorPanel(ss, dialog, this.app);
        dialog.add(ssep);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (SecondaryStructureEditorWizardNoThread.this.finished) {
                    return;
                }
                SecondaryStructureEditorWizardNoThread.this.structure = ssep.getSecondaryStructure();
                SecondaryStructureEditorWizardNoThread.this.finished = true;
                SecondaryStructureEditorWizardNoThread.this.fireActionPerformed(new ActionEvent(SecondaryStructureEditorWizardNoThread.this, 0, "update nanotiler with secondary structure information"));
            }
        });
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.setLocationRelativeTo(c);
        System.out.println("Showing window");
        dialog.setVisible(true);
    }
}

