/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Properties;
import rnadesign.designapp.rnagui.AbstractGeometryPainter;
import rnadesign.rnacontrol.CameraController;
import tools3d.Character3D;
import tools3d.Drawable;
import tools3d.Edge3D;
import tools3d.Face3D;
import tools3d.GeometryColorModel;
import tools3d.Point3D;
import tools3d.Vector3D;

public class SolidGeometryPainter
extends AbstractGeometryPainter {
    public static final int FACE_POINT_MAX = 3;
    private double pointRadius = 2.0;
    private static final double MAX_RADIUS = 30.0;
    static final BasicStroke stroke = new BasicStroke(2.0f);
    private static final Vector3D zeroPos = new Vector3D(0.0, 0.0, 0.0);
    private int[] xTmp = new int[3];
    private int[] yTmp = new int[3];

    @Override
    public void paintCharacter(Graphics g, Character3D point) {
        if (!this.paintCharacterMode) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Color saveColor = g2.getColor();
        char[] characters = new char[]{point.getCharacter()};
        if (point.getAppearance() != null) {
            g2.setColor(point.getAppearance().getColor());
        } else {
            g2.setColor(this.getDefaultPaintColor(point));
        }
        Vector3D pos3d = point.getPosition();
        CameraController camera = this.getCameraController();
        Point2D point2d = camera.project(point.getPosition());
        g.drawChars(characters, 0, 1, (int)point2d.getX(), (int)point2d.getY());
        g.setColor(saveColor);
    }

    @Override
    public void paintPoint(Graphics g, Point3D point) {
        Graphics2D g2 = (Graphics2D)g;
        CameraController camera = this.getCameraController();
        Vector3D pos3d = point.getPosition();
        Point2D point2d = camera.project(point.getPosition());
        if (point2d.getX() < 0.0 || point2d.getY() < 0.0) {
            return;
        }
        Color saveColor = g2.getColor();
        Color color = point.getAppearance() != null ? point.getAppearance().getColor() : this.getDefaultPaintColor(point);
        g2.setColor(color);
        g2.setStroke(stroke);
        double radius = point.getRadius();
        if (radius < this.pointRadius) {
            radius = this.pointRadius;
        }
        double tmpRadius = radius *= camera.getZoom();
        double halfRadius = 0.5 * tmpRadius;
        if (!(radius > 3.0)) {
            g2.drawRect((int)(point2d.getX() - halfRadius), (int)(point2d.getY() - halfRadius), (int)(2.0 * radius), (int)(2.0 * radius));
            g2.setColor(saveColor);
            return;
        }
        g2.fill(new Ellipse2D.Double(point2d.getX() - halfRadius, point2d.getY() - halfRadius, radius, radius));
        int numCircles = 5;
        Color currentPaint = color.brighter();
        double inset = radius / (double)numCircles;
        for (int i = 1; i < numCircles && !((tmpRadius = radius - (double)i * inset) < 3.0); ++i) {
            int redInc = (255 - currentPaint.getRed()) / numCircles;
            int greenInc = (255 - currentPaint.getGreen()) / numCircles;
            int blueInc = (255 - currentPaint.getBlue()) / numCircles;
            halfRadius = tmpRadius / 2.0;
            currentPaint = new Color(currentPaint.getRed() + redInc, currentPaint.getGreen() + greenInc, currentPaint.getBlue() + blueInc);
            g2.setColor(currentPaint);
            g2.fill(new Ellipse2D.Double(point2d.getX() - halfRadius, point2d.getY() - halfRadius, tmpRadius, tmpRadius));
        }
        g2.setColor(saveColor);
    }

    @Override
    public void paintEdge(Graphics g, Edge3D edge) {
        if (!this.getPaintLinks()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Color saveColor = g2.getColor();
        Properties properties = edge.getProperties();
        String physicalKey = "watson_crick";
        String chemicalKey = "backbone";
        CameraController camera = this.getCameraController();
        if (edge.getAppearance() != null) {
            g2.setColor(edge.getAppearance().getColor());
        } else if (properties != null && physicalKey.equals(properties.getProperty("interaction_type")) || chemicalKey.equals(properties.getProperty("interaction_type"))) {
            g2.setColor(this.geometryColorModel.computeColor(this.getAmbiente(), edge.getAppearance(), edge.getProperties(), null, camera.getCamera()));
        } else {
            g2.setColor(this.getDefaultPaintColor(edge));
        }
        Vector3D first3d = edge.getFirst();
        Vector3D second3d = edge.getSecond();
        Point2D first2d = camera.project(first3d);
        Point2D second2d = camera.project(second3d);
        g2.drawLine((int)first2d.getX(), (int)first2d.getY(), (int)second2d.getX(), (int)second2d.getY());
        g2.setColor(saveColor);
    }

    @Override
    public void paintFace(Graphics g, Face3D face) {
        int nn = face.size();
        if (nn > 3) {
            nn = 3;
        }
        if (nn < 3) {
            return;
        }
        CameraController camera = this.getCameraController();
        GeometryColorModel colorModel = this.getGeometryColorModel();
        for (int i = 0; i < nn; ++i) {
            Vector3D v = face.getPoint(i);
            Point2D p2d = camera.project(v);
            this.xTmp[i] = (int)p2d.getX();
            this.yTmp[i] = (int)p2d.getY();
        }
        Polygon polygon = new Polygon(this.xTmp, this.yTmp, nn);
        Graphics2D g2 = (Graphics2D)g;
        Color saveColor = g2.getColor();
        Vector3D normal = face.getNormal();
        Color color = colorModel.computeColor(this.getAmbiente(), face.getAppearance(), face.getProperties(), normal, camera.getCamera());
        g2.setColor(color);
        g2.fill(polygon);
        g2.setColor(saveColor);
    }

    @Override
    public boolean isPaintable(Drawable p) {
        return super.isPaintable(p);
    }
}

