/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.designapp.rnagui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import rnadesign.designapp.rnagui.GeneralWizard;
import rnadesign.rnacontrol.Object3DGraphController;
import rnadesign.rnacontrol.SequenceController;
import sequence.Sequence;

public class StemWizard
implements GeneralWizard {
    public static Logger log = Logger.getLogger("NanoTiler_debug");
    public static final int FIELD_INT_LENGTH = 5;
    public static final int FIELD_STRING_LENGTH = 15;
    private boolean finished = false;
    private JFrame frame = null;
    private JList leftList;
    private JList rightList;
    private JTextField startPosField;
    private JTextField stopPosField;
    private JTextField lengthField;
    private JTextField stemNameField;
    private JCheckBox interpolateCheckBox;
    private JCheckBox setEqualCheckBox;
    private List<ActionListener> actionListeners = new ArrayList<ActionListener>();
    private String[] sequenceNames;
    private Sequence[] sequences;
    private int sequenceSelection1 = 0;
    private int sequenceSelection2 = 0;
    private int start = 0;
    private int stop = 0;
    private int length = 0;
    private boolean interpolateMode = true;
    private boolean setEqualMode = true;
    private String stemName;
    private Object3DGraphController graphController;
    public static final String FRAME_TITLE = "Generate Stem Wizard";

    @Override
    public void addActionListener(ActionListener listener) {
        this.actionListeners.add(listener);
    }

    public void cleanUp() {
        if (this.frame != null) {
            this.frame.setVisible(false);
            this.frame = null;
        }
        this.finished = true;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public void launchWizard(Object3DGraphController graphController, Component parentFrame) {
        if (graphController == null) {
            log.info("GraphController received by launchWizard is null!");
        }
        this.graphController = graphController;
        boolean result = this.checkValues();
        if (result) {
            this.frame = new JFrame(FRAME_TITLE);
            this.addComponents(this.frame);
            this.frame.pack();
            this.frame.setVisible(true);
        } else {
            JOptionPane.showMessageDialog(parentFrame, "No sequences defined so far!");
        }
    }

    public void addComponents(JFrame _frame) {
        Container f = _frame.getContentPane();
        f.setLayout(new BorderLayout());
        JPanel center = new JPanel();
        center.setLayout(new FlowLayout());
        center.setPreferredSize(new Dimension(300, 200));
        if (this.graphController == null) {
            log.info("GraphController is null before generating left and right tree panels!");
        }
        SequenceController sequences = this.graphController.getSequences();
        String[] names = new String[sequences.getSequenceCount()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = sequences.getSequenceName(i);
        }
        this.leftList = new JList<String>(names);
        this.rightList = new JList<String>(names);
        JLabel leftLabel = new JLabel("Match: ");
        JLabel rightLabel = new JLabel("With: ");
        center.add(leftLabel);
        center.add(this.leftList);
        center.add(rightLabel);
        center.add(this.rightList);
        f.add((Component)center, "Center");
        JPanel middlePanel = new JPanel();
        JPanel lowerMiddlePanel = new JPanel();
        this.startPosField = new JTextField("" + (this.start + 1), 5);
        this.stopPosField = new JTextField("" + (this.stop + 1), 5);
        this.lengthField = new JTextField("" + this.length, 5);
        this.stemNameField = new JTextField("", 15);
        this.setEqualCheckBox = new JCheckBox("Set residue positions:", true);
        this.interpolateCheckBox = new JCheckBox("Interpolate residue positions:", true);
        middlePanel.setPreferredSize(new Dimension(300, 200));
        middlePanel.setLayout(new FlowLayout());
        middlePanel.add(new JLabel("Start: "));
        middlePanel.add(this.startPosField);
        middlePanel.add(new JLabel("Stop: "));
        middlePanel.add(this.stopPosField);
        middlePanel.add(new JLabel("Length: "));
        middlePanel.add(this.lengthField);
        lowerMiddlePanel.add(this.setEqualCheckBox);
        lowerMiddlePanel.add(this.interpolateCheckBox);
        JPanel bottomPanel = new JPanel();
        bottomPanel.setPreferredSize(new Dimension(300, 200));
        JButton button = new JButton("Cancel");
        button.addActionListener(new CancelListener());
        bottomPanel.add(button);
        button = new JButton("Done");
        button.addActionListener(new DoneListener());
        bottomPanel.add(button);
        JPanel southPanel = new JPanel();
        southPanel.setLayout(new BoxLayout(southPanel, 1));
        southPanel.add(middlePanel);
        southPanel.add(lowerMiddlePanel);
        southPanel.add(new JLabel("Name:"));
        southPanel.add(this.stemNameField);
        southPanel.add(bottomPanel);
        f.add((Component)southPanel, "South");
    }

    private boolean checkValues() {
        int numSeq = this.graphController.getSequences().getSequenceCount();
        return numSeq != 0;
    }

    private void readOutValues() {
        this.sequenceSelection1 = this.leftList.getSelectedIndex();
        this.sequenceSelection2 = this.rightList.getSelectedIndex();
        this.start = Integer.parseInt(this.startPosField.getText().trim()) - 1;
        this.stop = Integer.parseInt(this.stopPosField.getText().trim()) - 1;
        this.length = Integer.parseInt(this.lengthField.getText().trim());
        this.interpolateMode = this.interpolateCheckBox.isSelected();
        this.setEqualMode = this.setEqualCheckBox.isSelected();
        this.stemName = this.stemNameField.getText().trim();
    }

    private boolean isValid() {
        this.readOutValues();
        return this.start >= 0 && this.stop >= 0 && this.length > 0 && this.stemName != null && this.stemName.length() > 0 && this.leftList.getSelectedIndex() != this.rightList.getSelectedIndex();
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StemWizard.this.cleanUp();
        }
    }

    private class DoneListener
    implements ActionListener {
        private DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StemWizard.this.readOutValues();
            if (StemWizard.this.isValid()) {
                StemWizard.this.cleanUp();
            } else {
                JOptionPane.showMessageDialog(StemWizard.this.frame, "The current stem parameters are not ok!");
            }
        }
    }
}

