/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import rnadesign.rnacontrol.Kaleidoscope;
import symmetry.Cell;
import tools3d.LatticeSection;
import tools3d.Positionable3D;
import tools3d.Vector3D;
import tools3d.ZBuffer;

public class CellKaleidoscope
implements Kaleidoscope {
    Cell cell;
    LatticeSection section;

    public CellKaleidoscope(Cell cell, LatticeSection section) {
        this.cell = cell;
        this.section = section;
    }

    @Override
    public void apply(ZBuffer zBuffer) {
        assert (this.section.getVolume() > 1);
        int origSize = zBuffer.size();
        for (int i = this.section.getXMin(); i < this.section.getXMax(); ++i) {
            Vector3D shiftX = this.cell.getX().mul(i);
            for (int j = this.section.getYMin(); j < this.section.getYMax(); ++j) {
                Vector3D shiftY = this.cell.getY().mul(j);
                for (int k = this.section.getZMin(); k < this.section.getZMax(); ++k) {
                    if (i == 0 && j == 0 && k == 0) continue;
                    Vector3D shiftZ = this.cell.getZ().mul(k);
                    Vector3D shift = shiftX.plus(shiftY).plus(shiftZ);
                    for (int ii = 0; ii < origSize; ++ii) {
                        Positionable3D newPos = (Positionable3D)zBuffer.get(ii).cloneDeep();
                        newPos.translate(shift);
                        zBuffer.add(newPos);
                    }
                }
            }
        }
    }

    @Override
    public int getSymmetryCount() {
        return this.section.getVolume();
    }
}

