/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnacontrol;

import controltools.ModelChangeEvent;
import controltools.ModelChangeListener;
import generaltools.ParsingException;
import generaltools.StringTools;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import rnadesign.rnacontrol.SequenceController;
import rnadesign.rnamodel.FittingException;
import rnadesign.rnamodel.InteractionLink;
import rnadesign.rnamodel.Nucleotide3D;
import rnadesign.rnamodel.Residue3D;
import rnadesign.rnamodel.RnaModelException;
import rnadesign.rnamodel.RnaStrand;
import rnadesign.rnamodel.RnaStrandTools;
import sequence.DnaTools;
import sequence.DuplicateNameException;
import sequence.Sequence;
import sequence.SimpleLetterSymbol;
import sequence.SimpleUnevenAlignment;
import sequence.UnevenAlignment;
import sequence.UnknownSymbolException;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;

public class SimpleSequenceController
implements SequenceController,
ModelChangeListener {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private List<Sequence> sequences = new ArrayList<Sequence>();

    @Override
    public void addSequence(Sequence sequence) {
        this.sequences.add(sequence);
    }

    @Override
    public void clear() {
        this.sequences.clear();
    }

    @Override
    public int getSequenceId(Sequence s) {
        if (s == null) {
            return -1;
        }
        for (int i = 0; i < this.sequences.size(); ++i) {
            if (!s.getName().equals(this.getSequence(i).getName())) continue;
            return i;
        }
        return -1;
    }

    public String getLastToken(StringTokenizer tokens) {
        String lastToken = null;
        while (tokens.hasMoreTokens()) {
            lastToken = tokens.nextToken();
        }
        return lastToken;
    }

    @Override
    public int getSequenceId(String name) {
        if (name == null) {
            return -1;
        }
        StringTokenizer tokens = new StringTokenizer(name, ".");
        if (tokens.countTokens() > 1) {
            name = this.getLastToken(tokens);
        }
        log.fine("Using effective Sequence name: " + name);
        for (int i = 0; i < this.sequences.size(); ++i) {
            if (!name.equals(this.getSequence(i).getName())) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Sequence getSequence(int n) {
        return this.sequences.get(n);
    }

    @Override
    public Sequence getSequence(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.getSequenceCount(); ++i) {
            if (!this.getSequence(i).getName().equals(name)) continue;
            return this.getSequence(i);
        }
        return null;
    }

    @Override
    public String getSequenceName(int n) {
        return this.getSequence(n).getName();
    }

    @Override
    public int getSequenceCount() {
        return this.sequences.size();
    }

    @Override
    public String[] getSequenceStrings() {
        String[] result = new String[this.getSequenceCount()];
        for (int i = 0; i < this.getSequenceCount(); ++i) {
            result[i] = this.getSequence(i).sequenceString();
        }
        return result;
    }

    @Override
    public void modelChanged(ModelChangeEvent e) {
    }

    @Override
    public UnevenAlignment getUnevenAlignment() throws DuplicateNameException {
        SimpleUnevenAlignment result = new SimpleUnevenAlignment();
        for (int i = 0; i < this.getSequenceCount(); ++i) {
            result.addSequence(this.getSequence(i));
        }
        return result;
    }

    private boolean linkConsistencyCheck(InteractionLink link) {
        return link.isValid();
    }

    private boolean linkConsistencyCheck(LinkSet links) {
        for (int i = 0; i < links.size(); ++i) {
            Link link = links.get(i);
            if (!(link instanceof InteractionLink) || this.linkConsistencyCheck((InteractionLink)link)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void overwriteSequence(Sequence s, int n, Object3D nucleotideDB, double rmsLimit, LinkSet links) {
        log.fine("Starting SimpleSequenceController.overwriteSequence " + n);
        Sequence seq = this.getSequence(n);
        if (seq instanceof RnaStrand) {
            RnaStrand strand = (RnaStrand)seq;
            assert (strand.getResidueCount() == s.size());
            for (int i = 0; i < strand.size(); ++i) {
                if (strand.getResidue(i).getSymbol().equals(s.getResidue(i).getSymbol())) continue;
                log.fine("Mutating residue " + (i + 1) + " of strand " + strand.getName());
                try {
                    RnaStrandTools.mutateResidue(strand, s.getResidue(i).getSymbol(), i, nucleotideDB, rmsLimit, links);
                    strand.getResidue(i).setProperty("sequence_status", "optimized");
                    if ($assertionsDisabled || strand.getResidue(i).getSymbol().equals(s.getResidue(i).getSymbol())) continue;
                    throw new AssertionError();
                }
                catch (RnaModelException rme) {
                    log.warning("Cannot mutate residue " + (i + 1) + " " + rme.getMessage());
                    continue;
                }
                catch (FittingException rme) {
                    log.warning("Fitting exception while mutating residue " + (i + 1) + " : " + rme.getMessage());
                }
            }
            assert (this.linkConsistencyCheck(links));
        } else {
            log.warning("Internal error: sequence n is not of type RnaStrand!");
        }
    }

    @Override
    public void overwriteSequence(String s, int n, Object3D nucleotideDB, double rmsLimit, LinkSet links) {
        log.fine("Starting SimpleSequenceController.overwriteSequence " + (n + 1));
        Sequence seq = this.getSequence(n);
        if (seq instanceof RnaStrand) {
            RnaStrand strand = (RnaStrand)seq;
            assert (strand.getResidueCount() == s.length());
            for (int i = 0; i < strand.size(); ++i) {
                if (strand.getResidue(i).getSymbol().getCharacter() == s.charAt(i)) continue;
                log.fine("Mutating residue " + (i + 1) + " of strand " + strand.getName());
                try {
                    SimpleLetterSymbol newSymbol = new SimpleLetterSymbol(s.charAt(i), DnaTools.AMBIGUOUS_RNA_ALPHABET);
                    RnaStrandTools.mutateResidue(strand, newSymbol, i, nucleotideDB, rmsLimit, links);
                    strand.getResidue(i).setProperty("sequence_status", "optimized");
                    if ($assertionsDisabled || strand.getResidue(i).getSymbol().equals(newSymbol)) continue;
                    throw new AssertionError();
                }
                catch (RnaModelException rme) {
                    log.warning("Cannot mutate residue " + (i + 1) + " " + rme.getMessage());
                    continue;
                }
                catch (FittingException rme) {
                    log.warning("Fitting exception while mutating residue " + (i + 1) + " : " + rme.getMessage());
                    continue;
                }
                catch (UnknownSymbolException use) {
                    log.warning("Unknown sequence symbol detected at position " + (i + 1) + " : " + s.charAt(i) + " " + s);
                }
            }
            assert (this.linkConsistencyCheck(links));
        } else {
            log.warning("Internal error: sequence n is not of type RnaStrand!");
        }
    }

    private List<Residue3D> collectChainResidues(String residueNames) throws ParsingException {
        String[] words = residueNames.split(":");
        if (words.length < 1) {
            throw new ParsingException("Expected residue specifier in the format chain:numbers . Example: B:3-5,8,19 or C:");
        }
        ArrayList<Residue3D> residues = new ArrayList<Residue3D>();
        String chainName = words[0];
        Sequence sequence = this.getSequence(chainName);
        if (sequence == null) {
            throw new ParsingException("Could not find sequence with name: " + chainName);
        }
        if (words.length == 1) {
            for (int i = 0; i < sequence.size(); ++i) {
                assert (sequence.getResidue(i) instanceof Residue3D);
                residues.add((Residue3D)sequence.getResidue(i));
            }
        } else if (words.length == 2) {
            List<Integer> ids = StringTools.parseNumbers(words[1]);
            for (Integer idObj : ids) {
                int id = idObj - 1;
                if (id < 0 || id >= sequence.size()) {
                    throw new ParsingException("Could not find residue with id " + idObj + " in sequence " + sequence.getName());
                }
                assert (sequence.getResidue(id) instanceof Residue3D);
                residues.add((Residue3D)sequence.getResidue(id));
            }
        } else {
            throw new ParsingException("Internal error! Expected residue specifier in the format chain:numbers . Example: B:3-5,8,19 or C:");
        }
        return residues;
    }

    private List<Residue3D> collectAllResidues() {
        ArrayList<Residue3D> residues = new ArrayList<Residue3D>();
        for (int i = 0; i < this.getSequenceCount(); ++i) {
            Sequence sequence = this.getSequence(i);
            for (int j = 0; j < sequence.size(); ++j) {
                assert (sequence.getResidue(j) instanceof Residue3D);
                residues.add((Residue3D)sequence.getResidue(j));
            }
        }
        return residues;
    }

    private void renumberResidues(Sequence sequence) {
        for (int i = 0; i < sequence.size(); ++i) {
            Nucleotide3D nuc = (Nucleotide3D)sequence.getResidue(i);
            nuc.setResidueNumberInName(i + 1);
        }
    }

    @Override
    public void renumberAllResidues() {
        for (int i = 0; i < this.getSequenceCount(); ++i) {
            Sequence sequence = this.getSequence(i);
            this.renumberResidues(sequence);
        }
    }

    @Override
    public List<Residue3D> collectResidues(String residueNames) throws ParsingException {
        ArrayList<Residue3D> residues = new ArrayList<Residue3D>();
        if (residueNames == null || residueNames.equals("")) {
            return residues;
        }
        if (residueNames.equals("all")) {
            return this.collectAllResidues();
        }
        String[] words = residueNames.split(";");
        for (int i = 0; i < words.length; ++i) {
            residues.addAll(this.collectChainResidues(words[i]));
        }
        return residues;
    }

    @Override
    public void setResiduesProperty(String residueNames, String key, String value) throws ParsingException {
        List<Residue3D> residues = this.collectResidues(residueNames);
        for (Residue3D residue : residues) {
            log.info("Setting property " + key + " of " + residue.infoString() + " to: " + value);
            residue.setProperty(key, value);
        }
    }

    @Override
    public void setResiduesStatus(String residueNames, String status) throws ParsingException {
        this.setResiduesProperty(residueNames, "sequence_status", status);
    }
}

