/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.List;
import java.util.Properties;
import rnadesign.rnamodel.BasepairOptimizer;
import tools3d.Vector3D;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3DSet;
import tools3d.symmetry2.SymCopies;

public class BasepairOptimizerTools {
    public static Properties optimizeBasepairs(LinkSet links, LinkSet basePairDB, int numSteps, double errorScoreLimit, double electrostaticWeight, double vdwWeight, double kt, List<Object3DSet> objectBlocks, List<Vector3D> fixedRotationAxisList, int[] symVdwActive, boolean keepFirstFixed, SymCopies symCopies) {
        assert (objectBlocks != null);
        assert (objectBlocks.size() > 0);
        BasepairOptimizer basepairOptimizer = new BasepairOptimizer(links, objectBlocks, numSteps, errorScoreLimit, basePairDB, symVdwActive, symCopies);
        basepairOptimizer.setElectrostaticWeight(electrostaticWeight);
        basepairOptimizer.setKeepFirstFixedMode(keepFirstFixed);
        basepairOptimizer.setVdwWeight(vdwWeight);
        if (fixedRotationAxisList != null) {
            basepairOptimizer.setFixedRotationAxis(fixedRotationAxisList);
        }
        basepairOptimizer.setKT(kt);
        Properties properties = basepairOptimizer.optimize();
        assert (properties != null);
        return properties;
    }
}

