/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.logging.Logger;
import rnadesign.rnamodel.GridTiler;
import rnadesign.rnamodel.StrandJunction3D;
import rnadesign.rnamodel.StrandJunctionDB;
import rnadesign.rnamodel.StrandJunctionTools;
import rnadesign.rnamodel.TilingStatistics;
import tools3d.Vector3D;
import tools3d.objects3d.Link;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.LinkTools;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3D;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;
import tools3d.objects3d.SimpleObject3DSet;

public class DebugGridTiler
implements GridTiler {
    private static Logger log = Logger.getLogger("NanoTiler_debug");
    private int verboseLevel = 0;
    private int junctionOrderMin = 1;
    private double scale = 50.0;
    private double directionLength = 5.0;
    private StrandJunctionDB strandJunctionDB;

    public DebugGridTiler(StrandJunctionDB strandJunctionDB) {
        this.strandJunctionDB = strandJunctionDB;
    }

    private StrandJunction3D placeJunction(int order, int id, String baseName) {
        assert (baseName != null);
        assert (this.strandJunctionDB != null && this.strandJunctionDB.isValid());
        log.fine("started placeJunction!");
        StrandJunction3D[] strandJunctions = this.strandJunctionDB.getJunctions(order);
        if (strandJunctions == null || strandJunctions.length < id) {
            return null;
        }
        assert (strandJunctions != null && strandJunctions.length > id);
        log.fine("number of database junctions with that order: " + strandJunctions.length);
        StrandJunction3D resultJunction = (StrandJunction3D)strandJunctions[id].cloneDeep();
        Vector3D newPos = new Vector3D((double)(order - 2) * this.scale, (double)id * this.scale, 0.0);
        resultJunction.setPosition(newPos);
        return resultJunction;
    }

    private Object3DSet placeJunctions(Object3DSet objectSet, LinkSet links, String baseName) {
        assert (objectSet != null);
        assert (links != null);
        assert (baseName != null);
        log.fine("Started placeJunctions!");
        SimpleObject3DSet result = new SimpleObject3DSet();
        SimpleObject3D newStrands = new SimpleObject3D();
        newStrands.setName(baseName + "_strands");
        for (int i = 0; i < this.strandJunctionDB.size(); ++i) {
            for (int j = 0; j < this.strandJunctionDB.size(i); ++j) {
                String name = baseName + "_junc" + (i + 1) + "_" + j;
                log.fine("Placing junction " + name);
                StrandJunction3D junction = this.placeJunction(i, j, baseName);
                if (junction.getBranchCount() < this.junctionOrderMin) {
                    junction = null;
                }
                if (junction != null) {
                    junction.setName(name);
                    StrandJunctionTools.placeStrands(junction, newStrands);
                    result.add(junction);
                    continue;
                }
                log.fine("Junction " + name + " could not be generated!");
                result.add(junction);
            }
        }
        result.add(newStrands);
        log.fine("ended placeJunctions!");
        return result;
    }

    Object3DSet findBranchDescriptors(Object3DSet junctions, LinkSet links) {
        SimpleObject3DSet resultSet = new SimpleObject3DSet();
        for (int i = 0; i < junctions.size(); ++i) {
            StrandJunction3D junction1 = (StrandJunction3D)junctions.get(i);
            for (int j = i + 1; j < junctions.size(); ++j) {
                StrandJunction3D junction2 = (StrandJunction3D)junctions.get(j);
                int linkIdx = junction1.findBranchConnectionLink(junction2, links);
                if (linkIdx < 0) continue;
                Link link = links.get(linkIdx);
                resultSet.add(link.getObj1());
                resultSet.add(link.getObj2());
                return resultSet;
            }
        }
        return resultSet;
    }

    @Override
    public Object3DLinkSetBundle generateTiling(Object3D objectTree, LinkSet links, String baseName, char defaultSequenceChar, boolean onlyFirstPathMode) {
        assert (objectTree != null);
        assert (links != null);
        assert (baseName != null);
        log.fine("started generateTiling!");
        SimpleObject3D resultTree = new SimpleObject3D();
        resultTree.setName(baseName);
        resultTree.setPosition(objectTree.getPosition());
        SimpleLinkSet newLinks = new SimpleLinkSet();
        SimpleObject3DSet vertexSet = new SimpleObject3DSet(objectTree);
        for (int i = vertexSet.size() - 1; i >= 0; --i) {
            if (LinkTools.countLinks(vertexSet.get(i), links) != 0) continue;
            vertexSet.remove(vertexSet.get(i));
        }
        Object3DSet junctions = this.placeJunctions(vertexSet, links, baseName);
        assert (junctions != null);
        for (int i = 0; i < junctions.size(); ++i) {
            if (junctions.get(i) == null) continue;
            resultTree.insertChild(junctions.get(i));
        }
        SimpleObject3DLinkSetBundle result = new SimpleObject3DLinkSetBundle(resultTree, newLinks);
        log.fine("Finished generateTiling!");
        assert (result != null);
        return result;
    }

    public int getVerboseLevel() {
        return this.verboseLevel;
    }

    public void setVerboseLevel(int n) {
        this.verboseLevel = n;
    }

    public TilingStatistics getTilingStatistics() {
        return null;
    }
}

