/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import rnadesign.rnamodel.BranchDescriptor3D;
import rnadesign.rnamodel.BranchDescriptorTools;
import rnadesign.rnamodel.BridgeFinder;
import rnadesign.rnamodel.ConnectJunctionTools;
import rnadesign.rnamodel.SimpleStrandJunctionDB;
import rnadesign.rnamodel.StrandJunction3D;
import tools3d.AxisAngle;
import tools3d.Matrix4D;
import tools3d.Matrix4DTools;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class HelixBridgeFinder
implements BridgeFinder {
    private List<StrandJunction3D> junctions;
    private Object3D nucleotideDB;
    private Logger log = Logger.getLogger("NanoTiler_debug");
    private double angleWeight = 10.0;
    private double rms = 2.0;
    private int solutionMax = 10;
    private int len1Max = 20;
    private int len2Max = 20;
    private int lenMin = 0;
    private int verboseLevel = 3;
    private boolean avgMode = false;
    private boolean inversionMode = true;
    private char c1 = (char)71;
    private char c2 = (char)67;

    public HelixBridgeFinder() {
    }

    public HelixBridgeFinder(List<StrandJunction3D> junctions, Object3D nucleotideDB) {
        this.junctions = junctions;
        this.nucleotideDB = nucleotideDB;
    }

    @Override
    public List<Object3DLinkSetBundle> findBridge(Object3D obj1, Object3D obj2) {
        this.log.info("Called HelixBridgeFinder : " + obj1.getFullName() + " " + obj2.getFullName() + " rms: " + this.rms + " verbose: " + this.verboseLevel);
        if (!(obj1 instanceof BranchDescriptor3D) || !(obj2 instanceof BranchDescriptor3D)) {
            this.log.warning("Expected BranchDescriptor3D data type: " + obj1.getFullName() + " " + obj2.getFullName());
            return null;
        }
        return this.findHelixBridge((BranchDescriptor3D)obj1, (BranchDescriptor3D)obj2);
    }

    public List<Object3DLinkSetBundle> findHelixBridge(BranchDescriptor3D bd1, BranchDescriptor3D bd2) {
        int prop = 1;
        double distOrig = bd1.distance(bd2);
        this.log.info("Trying to bridge distance " + distOrig);
        if (this.inversionMode) {
            double angle = bd1.getDirection().angle(bd2.getDirection());
            BranchDescriptorTools.invertBranchDescriptor(bd1, prop);
            BranchDescriptorTools.invertBranchDescriptor(bd2, prop);
            this.log.info("Inverted searching for junction with connector helices and angle: " + bd1.getFullName() + " " + bd2.getFullName() + " Angle: " + Math.toDegrees(angle) + " distance: " + distOrig);
            double distNew = bd1.distance(bd2);
            assert (distOrig != distNew);
            assert (Math.abs(distOrig - distNew) < 7.0);
        }
        double angle2 = bd1.getDirection().angle(bd2.getDirection());
        this.log.info("Searching for junction with helices and angle and distance:" + bd1.getFullName() + " " + bd2.getFullName() + " Angle: " + Math.toDegrees(angle2) + " dist: " + bd1.distance(bd2));
        ArrayList<Object3DLinkSetBundle> result = new ArrayList<Object3DLinkSetBundle>();
        if (!this.isValid()) {
            this.log.warning("No junctions defined in helix bridge finder!");
        } else {
            Matrix4D md = this.convertBranchDescriptorPairToMatrix(bd1, bd2);
            Matrix4D m1 = bd1.getCoordinateSystem().generateMatrix4D();
            Matrix4D m2 = bd2.getCoordinateSystem().generateMatrix4D();
            List<HelixJunctionSolution> solutions = this.findHelixBridge(md);
            if (!this.inversionMode) {
                BranchDescriptorTools.invertBranchDescriptor(bd1, prop);
                BranchDescriptorTools.invertBranchDescriptor(bd2, prop);
            }
            for (int i = 0; i < solutions.size() && i < this.solutionMax; ++i) {
                result.add(solutions.get(i).convertTo3D(m1, m2));
            }
            if (!this.inversionMode) {
                BranchDescriptorTools.invertBranchDescriptor(bd1, prop);
                BranchDescriptorTools.invertBranchDescriptor(bd2, prop);
            }
        }
        if (this.inversionMode) {
            BranchDescriptorTools.invertBranchDescriptor(bd1, prop);
            BranchDescriptorTools.invertBranchDescriptor(bd2, prop);
        }
        return result;
    }

    private Matrix4D convertBranchDescriptorPairToMatrix(BranchDescriptor3D bd1, BranchDescriptor3D bd2) {
        Matrix4D m1 = bd1.getCoordinateSystem().generateMatrix4D();
        Matrix4D m2 = bd2.getCoordinateSystem().generateMatrix4D();
        return this.convertBranchDescriptorPairToMatrix(m1, m2);
    }

    private Matrix4D convertBranchDescriptorPairToMatrix(Matrix4D m1, Matrix4D m2) {
        return m1.inverse().multiply(m2);
    }

    private List<HelixJunctionSolution> findHelixBridge(Matrix4D matrix) {
        assert (this.junctions != null);
        this.log.info("Called findHelixBridge: " + matrix);
        ArrayList<HelixJunctionSolution> result = new ArrayList<HelixJunctionSolution>();
        for (int i = 0; i < this.junctions.size(); ++i) {
            List<HelixJunctionSolution> junctionSol = this.findJunctionSolutions(matrix, i);
            for (HelixJunctionSolution sol : junctionSol) {
                if (!(sol.score <= this.rms)) continue;
                result.add(sol);
            }
        }
        Collections.sort(result);
        return result;
    }

    private List<HelixJunctionSolution> findHelixBridge2(BranchDescriptor3D scaffBd1, BranchDescriptor3D scaffBd2) {
        assert (this.junctions != null);
        ArrayList<HelixJunctionSolution> result = new ArrayList<HelixJunctionSolution>();
        for (int i = 0; i < this.junctions.size(); ++i) {
            List<HelixJunctionSolution> junctionSol = this.findJunctionSolutions2(scaffBd1, scaffBd2, i);
            for (HelixJunctionSolution sol : junctionSol) {
                if (!(sol.score <= this.rms)) continue;
                result.add(sol);
            }
        }
        Collections.sort(result);
        return result;
    }

    private List<HelixJunctionSolution> findJunctionSolutions(Matrix4D matrix, int junctionId) {
        ArrayList<HelixJunctionSolution> solutions = new ArrayList<HelixJunctionSolution>();
        StrandJunction3D junction = this.junctions.get(junctionId);
        for (int hid1 = 0; hid1 < junction.getBranchCount(); ++hid1) {
            for (int hid2 = 0; hid2 < junction.getBranchCount(); ++hid2) {
                if (hid1 == hid2) continue;
                solutions.addAll(this.findJunctionSolution(matrix, junctionId, hid1, hid2));
            }
        }
        return solutions;
    }

    private List<HelixJunctionSolution> findJunctionSolutions2(BranchDescriptor3D scaffBd1, BranchDescriptor3D scaffBd2, int junctionId) {
        ArrayList<HelixJunctionSolution> solutions = new ArrayList<HelixJunctionSolution>();
        StrandJunction3D junction = this.junctions.get(junctionId);
        for (int hid1 = 0; hid1 < junction.getBranchCount(); ++hid1) {
            for (int hid2 = 0; hid2 < junction.getBranchCount(); ++hid2) {
                if (hid1 == hid2) continue;
                solutions.addAll(this.findJunctionSolution2(scaffBd1, scaffBd2, junctionId, hid1, hid2));
            }
        }
        return solutions;
    }

    private List<HelixJunctionSolution> findJunctionSolution(Matrix4D matrix, int junctionId, int hid1, int hid2) {
        ArrayList<HelixJunctionSolution> solutions = new ArrayList<HelixJunctionSolution>();
        double bestScore = 1.0E30;
        for (int len1 = this.lenMin; len1 < this.len1Max; ++len1) {
            for (int len2 = this.lenMin; len2 < this.len2Max; ++len2) {
                double score = this.scoreJunctionSolution(matrix, junctionId, hid1, hid2, len1, len2);
                if (this.verboseLevel > 3) {
                    this.log.info("Testing bridge: id; " + junctionId + " h " + hid1 + " " + hid2 + " l: " + len1 + " " + len2 + " score: " + score);
                }
                if (!(score < this.rms)) continue;
                if (this.verboseLevel > 2 || score < bestScore) {
                    this.log.info("Feasible bridge found: id; " + junctionId + " h " + hid1 + " " + hid2 + " l: " + len1 + " " + len2 + " score: " + score);
                }
                bestScore = score;
                HelixJunctionSolution sol = new HelixJunctionSolution();
                sol.score = score;
                sol.junctionId = junctionId;
                sol.helixLen1 = len1;
                sol.helixLen2 = len2;
                sol.helixId1 = hid1;
                sol.helixId2 = hid2;
                solutions.add(sol);
            }
        }
        return solutions;
    }

    private List<HelixJunctionSolution> findJunctionSolution2(BranchDescriptor3D scaffBd1, BranchDescriptor3D scaffBd2, int junctionId, int hid1, int hid2) {
        ArrayList<HelixJunctionSolution> solutions = new ArrayList<HelixJunctionSolution>();
        double bestScore = 1.0E30;
        StrandJunction3D junction = this.junctions.get(junctionId);
        BranchDescriptor3D bd1 = junction.getBranch(hid1);
        BranchDescriptor3D bd2 = junction.getBranch(hid2);
        for (int len1 = 0; len1 < this.len1Max; ++len1) {
            for (int len2 = this.lenMin; len2 < this.len2Max; ++len2) {
                Properties fitResult = SimpleStrandJunctionDB.scoreJunctionLoopFit(scaffBd1, scaffBd2, bd1, bd2, len1, len2, this.angleWeight);
                assert (fitResult.getProperty("score") != null);
                double score = Double.parseDouble(fitResult.getProperty("score"));
                if (this.verboseLevel > 3) {
                    this.log.info("Testing bridge: id; " + junctionId + " h " + hid1 + " " + hid2 + " l: " + len1 + " " + len2 + " score: " + score);
                }
                if (!(score < this.rms)) continue;
                if (this.verboseLevel > 2 || score < bestScore) {
                    this.log.info("Feasible bridge found: id; " + junctionId + " h " + hid1 + " " + hid2 + " l: " + len1 + " " + len2 + " score: " + score);
                }
                bestScore = score;
                HelixJunctionSolution sol = new HelixJunctionSolution();
                sol.score = score;
                sol.junctionId = junctionId;
                sol.helixLen1 = len1;
                sol.helixLen2 = len2;
                sol.helixId1 = hid1;
                sol.helixId2 = hid2;
                solutions.add(sol);
            }
        }
        return solutions;
    }

    @Override
    public int getLenMin() {
        return 1;
    }

    @Override
    public int getLenMax() {
        return 1000;
    }

    @Override
    public double getRms() {
        return this.rms;
    }

    public boolean isValid() {
        return this.junctions != null && this.junctions.size() > 0;
    }

    private double scoreJunctionSolution(Matrix4D matrix, int junctionId, int hid1, int hid2, int len1, int len2) {
        assert (hid1 != hid2);
        BranchDescriptor3D bd1 = this.junctions.get(junctionId).getBranch(hid1);
        BranchDescriptor3D bd2 = this.junctions.get(junctionId).getBranch(hid2);
        Matrix4D jMatrix = this.convertBranchDescriptorPairToMatrix(bd1.generatePropagatedCoordinateSystem(len1).generateMatrix4D(), bd2.generatePropagatedCoordinateSystem(len2).generateMatrix4D());
        double result = this.scoreMatrixDifference(matrix, jMatrix);
        double result2 = this.scoreMatrixDifference(jMatrix, matrix);
        assert (Math.abs(result - result2) < 0.01);
        return result;
    }

    private double scoreMatrixDifference(Matrix4D m1, Matrix4D m2) {
        return AxisAngle.distanceQuatNorm(m1, m2, this.angleWeight);
    }

    public void setBasepairCharacters(char c1, char c2) {
        this.c1 = c1;
        this.c2 = c2;
    }

    @Override
    public void setAngleWeight(double weight) {
        this.angleWeight = weight;
    }

    public void setInversionMode(boolean m) {
        this.inversionMode = m;
    }

    @Override
    public void setLenMax(int n) {
        this.len1Max = n;
        this.len2Max = n;
    }

    @Override
    public void setLenMin(int n) {
        this.lenMin = n;
    }

    public void setJunctions(List<StrandJunction3D> junctions) {
        this.junctions = junctions;
    }

    @Override
    public void setRms(double rms) {
        this.rms = rms;
    }

    @Override
    public void setSolutionMax(int n) {
        this.solutionMax = n;
    }

    public void setVerboseLevel(int level) {
        this.verboseLevel = level;
    }

    private class HelixJunctionSolution
    implements Comparable<HelixJunctionSolution> {
        double score;
        int junctionId;
        int helixId1;
        int helixId2;
        int helixLen1;
        int helixLen2;

        private HelixJunctionSolution() {
        }

        @Override
        public int compareTo(HelixJunctionSolution sol2) {
            if (this.score < sol2.score) {
                return -1;
            }
            if (this.score > sol2.score) {
                return 1;
            }
            return 0;
        }

        public Object3DLinkSetBundle convertTo3D(Matrix4D orient1, Matrix4D orient2) {
            assert (this.helixId1 != this.helixId2);
            StrandJunction3D junction = (StrandJunction3D)((StrandJunction3D)HelixBridgeFinder.this.junctions.get(this.junctionId)).cloneDeep();
            assert (this.helixId1 >= 0 && this.helixId1 < junction.getBranchCount());
            assert (this.helixId2 >= 0 && this.helixId2 < junction.getBranchCount());
            Matrix4D m1 = junction.getBranch(this.helixId1).generatePropagatedCoordinateSystem(this.helixLen1).generateMatrix4D();
            Matrix4D m2 = junction.getBranch(this.helixId2).generatePropagatedCoordinateSystem(this.helixLen2).generateMatrix4D();
            Matrix4D conv1 = orient1.multiply(m1.inverse());
            if (HelixBridgeFinder.this.avgMode) {
                Matrix4D conv2 = orient2.multiply(m2.inverse());
                Matrix4D avgConv = Matrix4DTools.computeAverageTransformationQuat(conv1, conv2);
                junction.activeTransform(new CoordinateSystem3D(avgConv));
            } else {
                junction.activeTransform(new CoordinateSystem3D(conv1));
            }
            junction.setProperty("score", "" + this.score);
            junction.setProperty("junction_id", "" + (this.junctionId + 1));
            junction.setProperty("helix_id_1", "" + (this.helixId1 + 1));
            junction.setProperty("helix_id_2", "" + (this.helixId2 + 1));
            junction.setProperty("helix_len_1", "" + this.helixLen1);
            junction.setProperty("helix_len_2", "" + this.helixLen2);
            if (HelixBridgeFinder.this.nucleotideDB != null) {
                if (this.helixLen1 > 0) {
                    String stem1Name = "stem1";
                    junction.getBranch(this.helixId1).propagate(1);
                    Object3DLinkSetBundle stem1Bundle = ConnectJunctionTools.generateIdealStem(junction.getBranch(this.helixId1), HelixBridgeFinder.this.c1, HelixBridgeFinder.this.c2, stem1Name, HelixBridgeFinder.this.nucleotideDB, this.helixLen1);
                    junction.getBranch(this.helixId1).propagate(-1);
                    HelixBridgeFinder.this.log.info("Generated bridge stem 1: " + stem1Bundle.getObject3D().getFullName());
                    junction.insertChild(stem1Bundle.getObject3D());
                }
                if (this.helixLen2 > 0) {
                    String stem2Name = "stem2";
                    junction.getBranch(this.helixId2).propagate(1);
                    Object3DLinkSetBundle stem2Bundle = ConnectJunctionTools.generateIdealStem(junction.getBranch(this.helixId2), HelixBridgeFinder.this.c1, HelixBridgeFinder.this.c2, stem2Name, HelixBridgeFinder.this.nucleotideDB, this.helixLen2);
                    junction.getBranch(this.helixId2).propagate(-1);
                    HelixBridgeFinder.this.log.info("Generated bridge stem 2: " + stem2Bundle.getObject3D().getFullName());
                    junction.insertChild(stem2Bundle.getObject3D());
                }
            } else {
                HelixBridgeFinder.this.log.warning("Could not generate bridging helices because no reference nucleotides are defined!");
            }
            return new SimpleObject3DLinkSetBundle(junction, new SimpleLinkSet());
        }
    }
}

