/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import rnadesign.rnamodel.RnaConstants;
import tools3d.CoordinateSystem;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;

public class HelixParameters {
    public double rise;
    public double basePairsPerTurn;
    public double offset;
    public double phaseOffset;
    public double radius;
    private CoordinateSystem deformation;

    public HelixParameters() {
        this.rise = RnaConstants.HELIX_RISE;
        this.basePairsPerTurn = RnaConstants.HELIX_BASE_PAIRS_PER_TURN;
        this.offset = RnaConstants.HELIX_OFFSET;
        this.phaseOffset = RnaConstants.HELIX_PHASE_OFFSET;
        this.radius = RnaConstants.HELIX_RADIUS;
    }

    public HelixParameters(HelixParameters other) {
        this.rise = other.rise;
        this.basePairsPerTurn = other.basePairsPerTurn;
        this.offset = other.offset;
        this.phaseOffset = other.phaseOffset;
        this.radius = other.radius;
        this.deformation = other.deformation != null ? (CoordinateSystem)other.deformation.cloneDeep() : null;
    }

    public double computeCurvature() {
        return this.radius / (this.radius * this.radius + this.rise * this.rise);
    }

    public double computeTorsion() {
        return this.rise / (this.radius * this.radius + this.rise * this.rise);
    }

    public double getRise() {
        return this.rise;
    }

    public double getBasePairsPerTurn() {
        return this.basePairsPerTurn;
    }

    public CoordinateSystem getDeformation() {
        return this.deformation;
    }

    public double getOffset() {
        return this.offset;
    }

    public double getRadius() {
        return this.radius;
    }

    public void initDeformation() {
        this.deformation = new CoordinateSystem3D(Vector3D.ZVEC);
    }

    public void setRise(double rise) {
        this.rise = rise;
    }

    public void setBasePairsPerTurn(double x) {
        this.basePairsPerTurn = x;
    }

    public void setDeformation(CoordinateSystem deformation) {
        this.deformation = deformation;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    public void setPhaseOffset(double phaseOffset) {
        this.phaseOffset = phaseOffset;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public String toString() {
        String result = "rise: " + this.rise + " basePairsPerTurn: " + this.basePairsPerTurn + " offset: " + this.offset + " phaseOffset: " + this.phaseOffset + " radius: " + this.radius;
        if (this.deformation != null) {
            result = result + " def-x: " + this.deformation.getX() + " def-y: " + this.deformation.getY() + " def-z: " + this.deformation.getZ();
        }
        return result;
    }
}

