/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import rnadesign.rnamodel.AbstractPdbWriter;
import rnadesign.rnamodel.Atom3D;
import rnadesign.rnamodel.PackageConstants;
import tools3d.objects3d.LinkSet;
import tools3d.objects3d.Object3D;
import tools3d.objects3d.Object3DLinkSetBundle;
import tools3d.objects3d.Object3DLinkSetBundleWriter;
import tools3d.objects3d.Object3DSet;
import tools3d.objects3d.Object3DTools;
import tools3d.objects3d.SimpleLinkSet;
import tools3d.objects3d.SimpleObject3DLinkSetBundle;

public class HeteroAtomPdbWriter
extends AbstractPdbWriter
implements Object3DLinkSetBundleWriter {
    private boolean polygrafMode = true;

    @Override
    public int getFormatId() {
        return 3;
    }

    public HeteroAtomPdbWriter() {
        this.dialect = 2;
    }

    public String generateHeader(String description, String author) {
        StringBuffer buf = new StringBuffer();
        buf.append("BIOGRF  321" + PackageConstants.NEWLINE);
        buf.append("DESCRP " + description + PackageConstants.NEWLINE);
        buf.append("REMARK Created by " + author + " on " + new Date());
        buf.append("REMARK " + PackageConstants.NEWLINE);
        if (this.polygrafMode) {
            buf.append("FORCEFIELD DREIDING" + PackageConstants.NEWLINE);
            buf.append("FORMAT ATOM   (a6,1x,i5,1x,a5,1x,a3,1x,a1,1x,a5,3f10.5,1x,a5,i3,i2,1x,f8.5,f10.5)" + PackageConstants.NEWLINE);
        }
        return buf.toString();
    }

    private String generateFooter() {
        return "END" + PackageConstants.NEWLINE;
    }

    private String generateBody(Object3DSet atoms, String residueName, char strandChar, int residueCount) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < atoms.size(); ++i) {
            buf.append(this.writeHeteroAtom((Atom3D)atoms.get(i), residueName, strandChar, residueCount) + PackageConstants.NEWLINE);
        }
        return buf.toString();
    }

    private int getPdbAtomNumber(Object3D atom, int defaultId) {
        String idString = atom.getProperty("pdb_atom_id");
        int result = defaultId;
        if (idString == null) {
            return result;
        }
        try {
            result = Integer.parseInt(idString);
        }
        catch (NumberFormatException nfe) {
            return defaultId;
        }
        return result;
    }

    private String generateConnections(List<Integer> connections) {
        StringBuffer buf = new StringBuffer();
        buf.append("CONECT  ");
        for (int i = 0; i < connections.size(); ++i) {
            buf.append("   " + connections.get(i));
        }
        buf.append(PackageConstants.NEWLINE);
        return buf.toString();
    }

    private String generateConnection(int n, Object3DSet atoms, LinkSet links) {
        assert (n >= 0);
        assert (n < atoms.size());
        Atom3D atom = (Atom3D)atoms.get(n);
        ArrayList<Integer> linkIds = new ArrayList<Integer>();
        int thisId = this.getPdbAtomNumber(atom, n + 1);
        linkIds.add(new Integer(thisId));
        for (int i = 0; i < atoms.size(); ++i) {
            int linkNumber;
            if (i == n || (linkNumber = links.getLinkNumber(atom, atoms.get(i))) <= 0) continue;
            linkIds.add(new Integer(this.getPdbAtomNumber(atoms.get(i), i + 1)));
        }
        return this.generateConnections(linkIds);
    }

    private String generateConnections(Object3DSet atoms, LinkSet links) {
        StringBuffer buf = new StringBuffer();
        if (this.polygrafMode) {
            buf.append("FORMAT CONECT (a6,12i6)" + PackageConstants.NEWLINE);
        }
        for (int i = 0; i < atoms.size(); ++i) {
            buf.append(this.generateConnection(i, atoms, links));
        }
        return buf.toString();
    }

    private String generateLinks(Object3DSet atoms, LinkSet links) {
        StringBuffer buf = new StringBuffer();
        return buf.toString();
    }

    @Override
    public String toString(Object3DLinkSetBundle bundle) {
        String author;
        StringBuffer buf = new StringBuffer();
        Object3D obj = bundle.getObject3D();
        Object3DSet atoms = Object3DTools.collectByClassName(obj, "Atom3D");
        String residueName = obj.getName();
        if (residueName.length() > 3) {
            residueName = residueName.substring(0, 3);
        }
        residueName = residueName.toUpperCase();
        char strandChar = 'H';
        int residueCount = 1;
        String description = obj.getProperty("description");
        if (description == null || description.length() == 0) {
            description = "No description available.";
        }
        if ((author = obj.getProperty("author")) == null || author.length() == 0) {
            author = "NanoTiler";
        }
        buf.append(this.generateHeader(description, author));
        buf.append(this.generateBody(atoms, residueName, strandChar, residueCount));
        buf.append(this.generateConnections(atoms, bundle.getLinks()));
        buf.append(this.generateFooter());
        return buf.toString();
    }

    @Override
    public String writeString(Object3D node) {
        SimpleObject3DLinkSetBundle bundle = new SimpleObject3DLinkSetBundle(node, new SimpleLinkSet());
        return this.toString(bundle);
    }

    @Override
    public void write(OutputStream os, LinkSet links) {
        assert (false);
    }

    @Override
    public void write(OutputStream os, Object3D node) {
        assert (false);
    }
}

