/*
 * Decompiled with CFR 0.152.
 */
package rnadesign.rnamodel;

import generaltools.IOTools;
import generaltools.StringTools;
import java.awt.geom.NoninvertibleTransformException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import rnadesign.rnamodel.HelixParameters;
import rnadesign.rnamodel.JunctionHashGenerator;
import rnadesign.rnamodel.JunctionScanOutputParser;
import rnadesign.rnamodel.SimpleBranchDescriptor3D;
import tools3d.Matrix4D;
import tools3d.Matrix4DTools;
import tools3d.Vector3D;
import tools3d.objects3d.CoordinateSystem3D;
import tools3d.objects3d.Object3DTools;

class JunctionCompare {
    public static final double NOMATCH_SCORE = 1000.0;
    public static final int TEST_INTERVAL = 1000000;
    public static final int JUNCTION_ORDER_MAX = 4;
    public static double translationRandStep = 10.0;

    JunctionCompare() {
    }

    public static void main(String[] args) {
        int i;
        String[] allLines;
        if (args.length < 2) {
            System.out.println("All-versus-all comparison of a set of junctions (via their JunctionScanner output). Usage: java rnadesign.rnamodel.JunctionCompare n|r filenamefile|[file1 file2 file3 ...] ");
            System.exit(0);
        }
        boolean numFiles = false;
        ArrayList<String> fileNameList = new ArrayList<String>();
        ArrayList<String> fileNameList2 = new ArrayList<String>();
        String mode = args[0];
        if (args.length == 2) {
            try {
                FileInputStream is = new FileInputStream(args[1]);
                allLines = StringTools.readAllLines(is);
                for (int i2 = 0; i2 < allLines.length; ++i2) {
                    String s = allLines[i2].trim();
                    if (s.length() <= 0) continue;
                    fileNameList.add(s);
                    fileNameList2.add(s);
                }
            }
            catch (IOException ioe) {
                System.err.println("Error reading file with filenames: " + ioe.getMessage());
                System.exit(1);
            }
        } else if (args.length == 3) {
            try {
                FileInputStream is = new FileInputStream(args[1]);
                allLines = StringTools.readAllLines(is);
                for (int i3 = 0; i3 < allLines.length; ++i3) {
                    String s = allLines[i3].trim();
                    if (s.length() <= 0) continue;
                    fileNameList.add(s);
                }
                is.close();
                FileInputStream is2 = new FileInputStream(args[2]);
                allLines = StringTools.readAllLines(is2);
                for (int i4 = 0; i4 < allLines.length; ++i4) {
                    String s = allLines[i4].trim();
                    if (s.length() <= 0) continue;
                    fileNameList2.add(s);
                }
                is2.close();
            }
            catch (IOException ioe) {
                System.err.println("Error reading file with filenames: " + ioe.getMessage());
                System.exit(1);
            }
        } else {
            for (int i5 = 1; i5 < args.length; ++i5) {
                fileNameList.add(args[i5]);
            }
        }
        double[][] scoreMatrix = new double[fileNameList.size()][fileNameList2.size()];
        for (int i6 = 0; i6 < scoreMatrix.length; ++i6) {
            for (int j = 0; j < scoreMatrix[i6].length; ++j) {
                scoreMatrix[i6][j] = 1000.0;
            }
        }
        JunctionHashGenerator generator = new JunctionHashGenerator();
        HelixParameters helixParameters = new HelixParameters();
        CoordinateSystem3D randCoords = new CoordinateSystem3D(new Vector3D(0.0, 0.0, 0.0));
        if (mode.equals("r")) {
            System.out.println("Randomizing helix positions (orientation and translation)...");
            Object3DTools.randomizeOrientation(randCoords);
            Object3DTools.randomizeTranslation(randCoords, translationRandStep);
            System.out.println("" + randCoords);
        }
        for (i = 0; i < fileNameList.size(); ++i) {
            String filen1 = (String)fileNameList.get(i);
            System.out.println("# Working on file 1: " + filen1);
            try {
                FileInputStream fis1 = new FileInputStream(filen1);
                JunctionScanOutputParser parser = new JunctionScanOutputParser(fis1);
                parser.parse();
                fis1.close();
                List<CoordinateSystem3D> orientations1Orig = parser.getOrientations();
                if (mode.equals("r")) {
                    for (int ii = 0; ii < orientations1Orig.size(); ++ii) {
                        orientations1Orig.get(ii).activeTransform(randCoords);
                    }
                }
                List<CoordinateSystem3D> orientations1 = generator.generateNormalizedCoordinates(orientations1Orig, helixParameters);
                List<Matrix4D> trafos1 = generator.generateNormalizedTransformations(orientations1);
                if (i > 0 && i % 1000000 == 0) {
                    int ii;
                    System.out.println("# Starting self-test using file " + filen1);
                    Matrix4D randMatrix = Matrix4DTools.generateRandomHomogeneousMatrix(1.0, 1.0);
                    CoordinateSystem3D csRand = new CoordinateSystem3D(randMatrix);
                    ArrayList<CoordinateSystem3D> orientations1OrigClone = new ArrayList<CoordinateSystem3D>();
                    for (ii = 0; ii < orientations1Orig.size(); ++ii) {
                        CoordinateSystem3D newCs = (CoordinateSystem3D)orientations1Orig.get(ii).cloneDeep();
                        newCs.activeTransform3(csRand);
                        CoordinateSystem3D newCs2 = SimpleBranchDescriptor3D.generatePropagatedCoordinateSystem(newCs, helixParameters, 1);
                        if (ii == 0) {
                            orientations1OrigClone.add(newCs2);
                            continue;
                        }
                        orientations1OrigClone.add(newCs);
                    }
                    assert (orientations1OrigClone.size() == orientations1Orig.size());
                    for (ii = 0; ii < orientations1Orig.size(); ++ii) {
                        System.out.println("# Originally parsed orientations (1): " + ii + "\n");
                        System.out.println(orientations1Orig.get(ii) + "\n" + orientations1OrigClone.get(ii));
                    }
                    Vector3D p1 = new Vector3D(((CoordinateSystem3D)orientations1OrigClone.get(0)).getPosition());
                    List<CoordinateSystem3D> orientations1Clone = generator.generateNormalizedCoordinates(orientations1OrigClone, helixParameters);
                    Vector3D p2 = new Vector3D(((CoordinateSystem3D)orientations1OrigClone.get(0)).getPosition());
                    assert (p1.distance(p2) < 0.001);
                    List<Matrix4D> trafos1Clone = generator.generateNormalizedTransformations(orientations1Clone);
                    assert (trafos1.size() == trafos1Clone.size());
                    double scoreSelf = generator.scoreNormalizedTransformations(trafos1, trafos1);
                    double score = generator.scoreNormalizedTransformations(trafos1, trafos1Clone);
                    System.out.println("# result of self test " + (i + 1) + " " + IOTools.extractRelativeName((String)fileNameList.get(i)) + " : " + score + " " + scoreSelf + "\n");
                    if (Math.abs(score) >= 1.0E-4) {
                        for (int ii2 = 0; ii2 < trafos1.size(); ++ii2) {
                            System.out.println("# Originally parsed orientations: " + ii2 + "\n");
                            System.out.println(orientations1Orig.get(ii2) + "\n" + orientations1OrigClone.get(ii2));
                            System.out.println("# Normalized orientations: " + ii2 + "\n");
                            System.out.println(orientations1.get(ii2) + "\n" + orientations1Clone.get(ii2));
                            System.out.println("# Transformation " + ii2 + "\n");
                            System.out.println(trafos1.get(ii2) + "\n" + trafos1Clone.get(ii2));
                        }
                    }
                    assert (Math.abs(score) < 1.0E-4);
                }
                for (int j = 0; j < fileNameList2.size(); ++j) {
                    String filen2 = (String)fileNameList2.get(j);
                    try {
                        FileInputStream fis2 = new FileInputStream(filen2);
                        JunctionScanOutputParser parser2 = new JunctionScanOutputParser(fis2);
                        parser2.parse();
                        fis2.close();
                        List<CoordinateSystem3D> orientations2Orig = parser2.getOrientations();
                        if (mode.equals("r")) {
                            for (int ii = 0; ii < orientations2Orig.size(); ++ii) {
                                orientations2Orig.get(ii).activeTransform(randCoords);
                            }
                        }
                        List<CoordinateSystem3D> orientations2 = generator.generateNormalizedCoordinates(orientations2Orig, helixParameters);
                        List<Matrix4D> trafos2 = generator.generateNormalizedTransformations(orientations2);
                        if (trafos1.size() == trafos2.size() && trafos1.size() <= 4) {
                            assert (trafos1.size() == trafos2.size());
                            double score = generator.scoreNormalizedTransformations(trafos1, trafos2);
                            System.out.println("# Comparing " + (i + 1) + " " + IOTools.extractRelativeName(filen1) + " " + (j + 1) + " " + IOTools.extractRelativeName(filen2) + " : " + score);
                            scoreMatrix[i][j] = score;
                            continue;
                        }
                        scoreMatrix[i][j] = 1000.0;
                        continue;
                    }
                    catch (IOException ioe) {
                        System.out.println("# Warning: IO exception while processing file1: " + filen1 + " file2: " + filen2);
                        System.err.println(ioe.getMessage());
                        continue;
                    }
                    catch (DataFormatException dfe) {
                        System.out.println("# Warning: data format exception while processing file1: " + filen1 + " file2: " + filen2);
                        System.err.println(dfe.getMessage());
                        continue;
                    }
                    catch (NoninvertibleTransformException nite) {
                        System.out.println("# Warning: could not generate normalized coordinates. Current file1: " + filen1 + " file2: " + filen2);
                    }
                }
                continue;
            }
            catch (IOException ioe) {
                System.err.println(ioe.getMessage());
                continue;
            }
            catch (DataFormatException dfe) {
                System.err.println(dfe.getMessage());
                continue;
            }
            catch (NoninvertibleTransformException nite) {
                System.out.println("# Warning: could not generate normalized coordinates. Current file1: " + filen1);
            }
        }
        System.out.println("# Result matrix:");
        for (i = 0; i < scoreMatrix.length; ++i) {
            for (int j = 0; j < scoreMatrix[i].length; ++j) {
                System.out.print(scoreMatrix[i][j]);
                if (j + 1 >= scoreMatrix[i].length) continue;
                System.out.print(" ");
            }
            System.out.println();
        }
    }
}

